/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.GreaterEqEvaluator;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreaterEqCursor<V>
extends AbstractIndexCursor<V, ServerEntry> {
    private static final String UNSUPPORTED_MSG = "GreaterEqCursors only support positioning by element when a user index exists on the asserted attribute.";
    private final GreaterEqEvaluator greaterEqEvaluator;
    private final IndexCursor<V, ServerEntry> userIdxCursor;
    private final IndexCursor<String, ServerEntry> ndnIdxCursor;
    IndexEntry<String, ServerEntry> ndnCandidate;
    private boolean available = false;

    public GreaterEqCursor(Store<ServerEntry> db, GreaterEqEvaluator greaterEqEvaluator) throws Exception {
        this.greaterEqEvaluator = greaterEqEvaluator;
        String attribute = greaterEqEvaluator.getExpression().getAttribute();
        if (db.hasUserIndexOn(attribute)) {
            this.userIdxCursor = db.getUserIndex(attribute).forwardCursor();
            this.ndnIdxCursor = null;
        } else {
            this.ndnIdxCursor = db.getNdnIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void beforeValue(Long id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor != null) {
            if (this.greaterEqEvaluator.getComparator().compare(value, this.greaterEqEvaluator.getExpression().getValue().get()) <= 0) {
                this.beforeFirst();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.beforeValue(id, value);
        this.available = false;
    }

    @Override
    public void afterValue(Long id, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.greaterEqEvaluator.getComparator().compare(value, this.greaterEqEvaluator.getExpression().getValue().get());
            if (comparedValue == 0) {
                this.userIdxCursor.afterValue(id, value);
                this.available = false;
                return;
            }
            if (comparedValue < 0) {
                this.beforeFirst();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.afterValue(id, value);
        this.available = false;
    }

    @Override
    public void before(IndexEntry<V, ServerEntry> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            if (this.greaterEqEvaluator.getComparator().compare(element.getValue(), this.greaterEqEvaluator.getExpression().getValue().get()) <= 0) {
                this.beforeFirst();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.before((ServerEntry)((Object)element));
        this.available = false;
    }

    @Override
    public void after(IndexEntry<V, ServerEntry> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.greaterEqEvaluator.getComparator().compare(element.getValue(), this.greaterEqEvaluator.getExpression().getValue().get());
            if (comparedValue == 0) {
                this.userIdxCursor.after((ServerEntry)((Object)element));
                this.available = false;
                return;
            }
            if (comparedValue < 0) {
                this.beforeFirst();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.after((ServerEntry)((Object)element));
        this.available = false;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            ForwardIndexEntry advanceTo = new ForwardIndexEntry();
            advanceTo.setValue(this.greaterEqEvaluator.getExpression().getValue().get());
            this.userIdxCursor.before((ServerEntry)((Object)advanceTo));
        } else {
            this.ndnIdxCursor.beforeFirst();
            this.ndnCandidate = null;
        }
        this.available = false;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.ndnIdxCursor.afterLast();
            this.ndnCandidate = null;
        }
        this.available = false;
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.userIdxCursor != null) {
            while (this.userIdxCursor.previous()) {
                this.checkNotClosed("previous()");
                IndexEntry candidate = (IndexEntry)this.userIdxCursor.get();
                if (this.greaterEqEvaluator.getComparator().compare(candidate.getValue(), this.greaterEqEvaluator.getExpression().getValue().get()) < 0) continue;
                this.available = true;
                return true;
            }
            this.available = false;
            return false;
        }
        while (this.ndnIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            this.ndnCandidate = (IndexEntry)this.ndnIdxCursor.get();
            if (!this.greaterEqEvaluator.evaluate(this.ndnCandidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.userIdxCursor != null) {
            this.available = this.userIdxCursor.next();
            return this.available;
        }
        while (this.ndnIdxCursor.next()) {
            this.checkNotClosed("next()");
            this.ndnCandidate = (IndexEntry)this.ndnIdxCursor.get();
            if (!this.greaterEqEvaluator.evaluate(this.ndnCandidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public IndexEntry<V, ServerEntry> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            if (this.available) {
                return (IndexEntry)this.userIdxCursor.get();
            }
            throw new InvalidCursorPositionException("Cursor has not been positioned yet.");
        }
        if (this.available) {
            return this.ndnCandidate;
        }
        throw new InvalidCursorPositionException("Cursor has not been positioned yet.");
    }

    @Override
    public boolean isElementReused() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.isElementReused();
        }
        return this.ndnIdxCursor.isElementReused();
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.ndnIdxCursor.close();
        }
    }
}

