/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSubstringsFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitSubstringsFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitSubstringsFilterAction() {
        super("Initialize Substrings filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessageCodec ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequestCodec searchRequest = ldapMessage.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength == 0) {
            log.error("The Substring filter PDU must not be empty");
            throw new DecoderException("The Substring filter PDU must not be empty");
        }
        SubstringFilter substringFilter = new SubstringFilter(ldapMessageContainer.getTlvId());
        searchRequest.addCurrentFilter(substringFilter);
        searchRequest.setTerminalFilter(substringFilter);
        substringFilter.setExpectedLength(expectedLength);
        substringFilter.setCurrentLength(0);
        if (IS_DEBUG) {
            log.debug("Initialize Substrings filter");
        }
    }
}

