/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueControlCodec;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueControlContainer;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueControlStatesEnum;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueTags;
import org.apache.directory.shared.ldap.message.control.replication.SynchronizationInfoEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncInfoValueControlGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(SyncInfoValueControlGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static IGrammar instance = new SyncInfoValueControlGrammar();

    private SyncInfoValueControlGrammar() {
        this.name = SyncInfoValueControlGrammar.class.getName();
        this.statesEnum = SyncInfoValueControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[13][256];
        this.transitions[0][SyncInfoValueTags.NEW_COOKIE_TAG.getValue()] = new GrammarTransition(0, 1, SyncInfoValueTags.NEW_COOKIE_TAG.getValue(), new GrammarAction("NewCookie choice for SyncInfoValueControl"){

            public void action(IAsn1Container container) {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = new SyncInfoValueControlCodec(SynchronizationInfoEnum.NEW_COOKIE);
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                byte[] newCookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("newcookie = " + StringTools.dumpBytes(newCookie));
                }
                control.setCookie(newCookie);
                syncInfoValueContainer.grammarEndAllowed(true);
                syncInfoValueContainer.setSyncInfoValueControl(control);
            }
        });
        this.transitions[0][SyncInfoValueTags.REFRESH_DELETE_TAG.getValue()] = new GrammarTransition(0, 2, SyncInfoValueTags.REFRESH_DELETE_TAG.getValue(), new GrammarAction("RefreshDelete choice for SyncInfoValueControl"){

            public void action(IAsn1Container container) {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = new SyncInfoValueControlCodec(SynchronizationInfoEnum.REFRESH_DELETE);
                syncInfoValueContainer.setSyncInfoValueControl(control);
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[2][4] = new GrammarTransition(2, 3, 4, new GrammarAction("RefreshDelete cookie"){

            public void action(IAsn1Container container) {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = " + StringTools.dumpBytes(cookie));
                }
                syncInfoValueContainer.getSyncInfoValueControl().setCookie(cookie);
                syncInfoValueContainer.setSyncInfoValueControl(control);
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[3][1] = new GrammarTransition(3, 13, 1, new GrammarAction("RefreshDelete refreshDone flag"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDone = {}", refreshDone);
                    }
                    control.setRefreshDone(refreshDone);
                    syncInfoValueContainer.setSyncInfoValueControl(control);
                    syncInfoValueContainer.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = "failed to decode the refreshDone flag for SyncInfoValueControl";
                    LOG.error(msg, be);
                    throw new DecoderException(msg);
                }
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[2][1] = new GrammarTransition(2, 13, 1, new GrammarAction("RefreshDelete refreshDone flag"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDone = {}", refreshDone);
                    }
                    control.setRefreshDone(refreshDone);
                    syncInfoValueContainer.setSyncInfoValueControl(control);
                    syncInfoValueContainer.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = "failed to decode the refreshDone flag for SyncInfoValueControl";
                    LOG.error(msg, be);
                    throw new DecoderException(msg);
                }
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[0][SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue()] = new GrammarTransition(0, 5, SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue(), new GrammarAction("RefreshDelete choice for SyncInfoValueControl"){

            public void action(IAsn1Container container) {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = new SyncInfoValueControlCodec(SynchronizationInfoEnum.REFRESH_PRESENT);
                syncInfoValueContainer.setSyncInfoValueControl(control);
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[5][4] = new GrammarTransition(5, 6, 4, new GrammarAction("RefreshPresent cookie"){

            public void action(IAsn1Container container) {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = " + StringTools.dumpBytes(cookie));
                }
                syncInfoValueContainer.getSyncInfoValueControl().setCookie(cookie);
                syncInfoValueContainer.setSyncInfoValueControl(control);
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[6][1] = new GrammarTransition(6, 13, 1, new GrammarAction("RefreshPresent refreshDone flag"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDone = {}", refreshDone);
                    }
                    control.setRefreshDone(refreshDone);
                    syncInfoValueContainer.setSyncInfoValueControl(control);
                    syncInfoValueContainer.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = "failed to decode the refreshDone flag for SyncInfoValueControl";
                    LOG.error(msg, be);
                    throw new DecoderException(msg);
                }
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[5][1] = new GrammarTransition(5, 13, 1, new GrammarAction("RefreshPresent refreshDone flag"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDone = {}", refreshDone);
                    }
                    control.setRefreshDone(refreshDone);
                    syncInfoValueContainer.setSyncInfoValueControl(control);
                    syncInfoValueContainer.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = "failed to decode the refreshDone flag for SyncInfoValueControl";
                    LOG.error(msg, be);
                    throw new DecoderException(msg);
                }
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[0][SyncInfoValueTags.SYNC_ID_SET_TAG.getValue()] = new GrammarTransition(0, 8, SyncInfoValueTags.SYNC_ID_SET_TAG.getValue(), new GrammarAction("SyncIdSet choice for SyncInfoValueControl"){

            public void action(IAsn1Container container) {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = new SyncInfoValueControlCodec(SynchronizationInfoEnum.SYNC_ID_SET);
                syncInfoValueContainer.setSyncInfoValueControl(control);
            }
        });
        this.transitions[8][4] = new GrammarTransition(8, 9, 4, new GrammarAction("SyncIdSet cookie"){

            public void action(IAsn1Container container) {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = " + StringTools.dumpBytes(cookie));
                }
                syncInfoValueContainer.getSyncInfoValueControl().setCookie(cookie);
                syncInfoValueContainer.setSyncInfoValueControl(control);
            }
        });
        this.transitions[8][1] = new GrammarTransition(8, 10, 1, new GrammarAction("SyncIdSet refreshDeletes"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                try {
                    boolean refreshDeletes = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDeletes = {}", refreshDeletes);
                    }
                    control.setRefreshDeletes(refreshDeletes);
                    syncInfoValueContainer.setSyncInfoValueControl(control);
                }
                catch (BooleanDecoderException be) {
                    String msg = "failed to decode the refreshDeletes flag for SyncInfoValueControl";
                    LOG.error(msg, be);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[9][1] = new GrammarTransition(9, 10, 1, new GrammarAction("SyncIdSet refreshDeletes"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                try {
                    boolean refreshDeletes = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDeletes = {}", refreshDeletes);
                    }
                    control.setRefreshDeletes(refreshDeletes);
                    syncInfoValueContainer.setSyncInfoValueControl(control);
                }
                catch (BooleanDecoderException be) {
                    String msg = "failed to decode the refreshDeletes flag for SyncInfoValueControl";
                    LOG.error(msg, be);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[8][49] = new GrammarTransition(8, 11, 49, new GrammarAction("SyncIdSet syncUUIDs"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[9][49] = new GrammarTransition(9, 11, 49, new GrammarAction("SyncIdSet syncUUIDs"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[10][49] = new GrammarTransition(10, 11, 49, new GrammarAction("SyncIdSet syncUUIDs"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[11][4] = new GrammarTransition(11, 12, 4, new GrammarAction("SyncIdSet first UUID"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                byte[] uuid = value.getData();
                if (uuid == null || uuid.length != 16) {
                    String msg = "Bad UUID value, its length is incorrect ( it should be 16 bytes long)";
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                if (IS_DEBUG) {
                    LOG.debug("UUID = " + StringTools.dumpBytes(uuid));
                }
                control.getSyncUUIDs().add(uuid);
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[12][4] = new GrammarTransition(12, 12, 4, new GrammarAction("SyncIdSet UUID"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncInfoValueControlContainer syncInfoValueContainer = (SyncInfoValueControlContainer)container;
                SyncInfoValueControlCodec control = syncInfoValueContainer.getSyncInfoValueControl();
                Value value = syncInfoValueContainer.getCurrentTLV().getValue();
                byte[] uuid = value.getData();
                if (uuid == null || uuid.length != 16) {
                    String msg = "Bad UUID value, its length is incorrect ( it should be 16 bytes long)";
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                if (IS_DEBUG) {
                    LOG.debug("UUID = " + StringTools.dumpBytes(uuid));
                }
                control.getSyncUUIDs().add(uuid);
                syncInfoValueContainer.grammarEndAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

