/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.SynchronizedLRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;
    public static final int CACHE_MAX = 250;
    private final SynchronizedLRUMap cache;
    protected final Normalizer normalizer;

    public CachingNormalizer(Normalizer normalizer) {
        this(normalizer, 250);
    }

    public CachingNormalizer(Normalizer normalizer, int cacheSz) {
        this.normalizer = normalizer;
        this.cache = new SynchronizedLRUMap(cacheSz);
    }

    @Override
    public Value<?> normalize(Value<?> value) throws NamingException {
        if (value == null) {
            return null;
        }
        Value result = (Value)this.cache.get(value);
        if (result != null) {
            return result;
        }
        Value<?> normalized = this.normalizer.normalize(value);
        this.cache.put(value, normalized);
        return normalized;
    }

    @Override
    public String normalize(String value) throws NamingException {
        if (value == null) {
            return null;
        }
        String normalized = (String)this.cache.get(value);
        if (normalized != null) {
            return normalized;
        }
        normalized = this.normalizer.normalize(value);
        this.cache.put(value, normalized);
        return normalized;
    }
}

