/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIoProcessorPool<T extends AbstractIoSession>
implements IoProcessor<T> {
    private static final int DEFAULT_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    private static final AttributeKey PROCESSOR = new AttributeKey(SimpleIoProcessorPool.class, "processor");
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleIoProcessorPool.class);
    private final IoProcessor<T>[] pool;
    private final AtomicInteger processorDistributor = new AtomicInteger();
    private final Executor executor;
    private final boolean createdExecutor;
    private final Object disposalLock = new Object();
    private volatile boolean disposing;
    private volatile boolean disposed;

    public SimpleIoProcessorPool(Class<? extends IoProcessor<T>> processorType) {
        this(processorType, null, DEFAULT_SIZE);
    }

    public SimpleIoProcessorPool(Class<? extends IoProcessor<T>> processorType, int size) {
        this(processorType, null, size);
    }

    public SimpleIoProcessorPool(Class<? extends IoProcessor<T>> processorType, Executor executor) {
        this(processorType, executor, DEFAULT_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleIoProcessorPool(Class<? extends IoProcessor<T>> processorType, Executor executor, int size) {
        if (processorType == null) {
            throw new NullPointerException("processorType");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size: " + size + " (expected: positive integer)");
        }
        if (executor == null) {
            this.executor = executor = Executors.newCachedThreadPool();
            this.createdExecutor = true;
        } else {
            this.executor = executor;
            this.createdExecutor = false;
        }
        this.pool = new IoProcessor[size];
        boolean success = false;
        try {
            for (int i = 0; i < this.pool.length; ++i) {
                IoProcessor<T> processor = null;
                try {
                    try {
                        processor = processorType.getConstructor(ExecutorService.class).newInstance(executor);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    if (processor == null) {
                        try {
                            processor = processorType.getConstructor(Executor.class).newInstance(executor);
                        }
                        catch (NoSuchMethodException e) {
                            // empty catch block
                        }
                    }
                    if (processor == null) {
                        try {
                            processor = processorType.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (NoSuchMethodException e) {}
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeIoException("Failed to create a new instance of " + processorType.getName(), e);
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.valueOf(processorType) + " must have a public constructor " + "with one " + ExecutorService.class.getSimpleName() + " parameter, " + "a public constructor with one " + Executor.class.getSimpleName() + " parameter or a public default constructor.");
                }
                this.pool[i] = processor;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.dispose();
            }
        }
    }

    @Override
    public final void add(T session) {
        this.getProcessor(session).add(session);
    }

    @Override
    public final void flush(T session) {
        this.getProcessor(session).flush(session);
    }

    @Override
    public final void remove(T session) {
        this.getProcessor(session).remove(session);
    }

    @Override
    public final void updateTrafficControl(T session) {
        this.getProcessor(session).updateTrafficControl(session);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean isDisposing() {
        return this.disposing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        if (this.disposed) {
            return;
        }
        Object object = this.disposalLock;
        synchronized (object) {
            if (!this.disposing) {
                this.disposing = true;
                for (int i = this.pool.length - 1; i >= 0; --i) {
                    if (this.pool[i] == null || this.pool[i].isDisposing()) continue;
                    try {
                        this.pool[i].dispose();
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to dispose a " + this.pool[i].getClass().getSimpleName() + " at index " + i + ".", e);
                        continue;
                    }
                    finally {
                        this.pool[i] = null;
                    }
                }
                if (this.createdExecutor) {
                    ((ExecutorService)this.executor).shutdown();
                }
            }
        }
        this.disposed = true;
    }

    private IoProcessor<T> getProcessor(T session) {
        IoProcessor oldp;
        IoProcessor p = (IoProcessor)((AbstractIoSession)session).getAttribute(PROCESSOR);
        if (p == null && (oldp = (IoProcessor)((AbstractIoSession)session).setAttributeIfAbsent(PROCESSOR, p = this.nextProcessor())) != null) {
            p = oldp;
        }
        return p;
    }

    private IoProcessor<T> nextProcessor() {
        this.checkDisposal();
        return this.pool[Math.abs(this.processorDistributor.getAndIncrement()) % this.pool.length];
    }

    private void checkDisposal() {
        if (this.disposed) {
            throw new IllegalStateException("A disposed processor cannot be accessed.");
        }
    }
}

