/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw;

import java.io.IOException;
import java.util.ArrayList;
import javax.naming.InvalidNameException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.changepw.protocol.ChangePasswordProtocolHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.store.DirectoryPrincipalStore;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.transport.socket.DatagramAcceptor;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePasswordServer
extends DirectoryBackedService {
    private static final long serialVersionUID = 3509208713288140629L;
    private static final Logger LOG = LoggerFactory.getLogger(ChangePasswordServer.class.getName());
    private static final String SERVICE_PRINCIPAL_DEFAULT = "kadmin/changepw@EXAMPLE.COM";
    private static final String REALM_DEFAULT = "EXAMPLE.COM";
    private static final int DEFAULT_IP_PORT = 464;
    public static final String[] ENCRYPTION_TYPES_DEFAULT = new String[]{"des-cbc-md5"};
    private static final long DEFAULT_ALLOWABLE_CLOCKSKEW = 300000L;
    private static final boolean DEFAULT_EMPTY_ADDRESSES_ALLOWED = true;
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    public static final int DEFAULT_CATEGORY_COUNT = 3;
    public static final int DEFAULT_TOKEN_SIZE = 3;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.changepw";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS Change Password Service";
    private EncryptionType[] encryptionTypes;
    private String primaryRealm = "EXAMPLE.COM";
    private String servicePrincipal = "kadmin/changepw@EXAMPLE.COM";
    private long allowableClockSkew = 300000L;
    private boolean isEmptyAddressesAllowed = true;
    private int policyPasswordLength;
    private int policyCategoryCount;
    private int policyTokenSize;

    public ChangePasswordServer() {
        super.setServiceName(SERVICE_NAME_DEFAULT);
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setSearchBaseDn("ou=users,dc=example,dc=com");
        this.setTransports(new TcpTransport(464), new UdpTransport(464));
        this.prepareEncryptionTypes();
    }

    public String getPrimaryRealm() {
        return this.primaryRealm;
    }

    public void setPrimaryRealm(String primaryRealm) {
        this.primaryRealm = primaryRealm;
    }

    public EncryptionType[] getEncryptionTypes() {
        return this.encryptionTypes;
    }

    public void setEncryptionTypes(EncryptionType[] encryptionTypes) {
        this.encryptionTypes = encryptionTypes;
    }

    public long getAllowableClockSkew() {
        return this.allowableClockSkew;
    }

    public void setAllowableClockSkew(long allowableClockSkew) {
        this.allowableClockSkew = allowableClockSkew;
    }

    public KerberosPrincipal getServicePrincipal() {
        return new KerberosPrincipal(this.servicePrincipal);
    }

    public void setServicePrincipal(String servicePrincipal) {
        this.servicePrincipal = servicePrincipal;
    }

    public boolean isEmptyAddressesAllowed() {
        return this.isEmptyAddressesAllowed;
    }

    public void setEmptyAddressesAllowed(boolean isEmptyAddressesAllowed) {
        this.isEmptyAddressesAllowed = isEmptyAddressesAllowed;
    }

    public int getPasswordLengthPolicy() {
        return this.policyPasswordLength;
    }

    public int getCategoryCountPolicy() {
        return this.policyCategoryCount;
    }

    public int getTokenSizePolicy() {
        return this.policyTokenSize;
    }

    public void start() throws IOException, InvalidNameException {
        DirectoryPrincipalStore store = new DirectoryPrincipalStore(this.getDirectoryService(), new DN(this.getSearchBaseDn()));
        if (this.transports == null || this.transports.size() == 0) {
            UdpTransport transport = new UdpTransport(464);
            this.setTransports(transport);
            DatagramAcceptor acceptor = transport.getAcceptor();
            acceptor.setHandler(new ChangePasswordProtocolHandler(this, store));
            ((DatagramSessionConfig)acceptor.getSessionConfig()).setReuseAddress(true);
            acceptor.bind();
        } else {
            for (Transport transport : this.transports) {
                IoAcceptor acceptor = transport.getAcceptor();
                acceptor.setCloseOnDeactivation(false);
                if (transport instanceof UdpTransport) {
                    ((DatagramSessionConfig)acceptor.getSessionConfig()).setReuseAddress(true);
                } else {
                    ((SocketAcceptor)acceptor).setReuseAddress(true);
                    ((SocketAcceptor)acceptor).getSessionConfig().setTcpNoDelay(true);
                }
                acceptor.setHandler(new ChangePasswordProtocolHandler(this, store));
                acceptor.bind();
            }
        }
        LOG.info("ChangePassword service started.");
        System.out.println("ChangePassword service started.");
    }

    public void stop() {
        for (Transport transport : this.getTransports()) {
            IoAcceptor acceptor = transport.getAcceptor();
            if (acceptor == null) continue;
            acceptor.dispose();
        }
        LOG.info("ChangePassword service stopped.");
        System.out.println("ChangePassword service stopped.");
    }

    private void prepareEncryptionTypes() {
        String[] encryptionTypeStrings = ENCRYPTION_TYPES_DEFAULT;
        ArrayList<EncryptionType> encTypes = new ArrayList<EncryptionType>();
        for (String enc : encryptionTypeStrings) {
            for (EncryptionType type : EncryptionType.getEncryptionTypes()) {
                if (!type.toString().equalsIgnoreCase(enc)) continue;
                encTypes.add(type);
            }
        }
        this.encryptionTypes = encTypes.toArray(new EncryptionType[encTypes.size()]);
    }

    public void setPolicyPasswordLength(int policyPasswordLength) {
        this.policyPasswordLength = policyPasswordLength;
    }

    public void setPolicyCategoryCount(int policyCategoryCount) {
        this.policyCategoryCount = policyCategoryCount;
    }

    public void setPolicyTokenSize(int policyTokenSize) {
        this.policyTokenSize = policyTokenSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangePasswordServer[").append(this.getServiceName()).append("], listening on :").append('\n');
        if (this.getTransports() != null) {
            for (Transport transport : this.getTransports()) {
                sb.append("    ").append(transport).append('\n');
            }
        }
        return sb.toString();
    }
}

