/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.ArrayList;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapReferralException;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOperationManager
implements OperationManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOperationManager.class);
    private static final Logger LOG_CHANGES = LoggerFactory.getLogger("LOG_CHANGES");
    private final DirectoryService directoryService;

    public DefaultOperationManager(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    private LdapReferralException buildReferralException(ServerEntry parentEntry, DN childDn) throws NamingException, LdapURLEncodingException {
        EntryAttribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        for (Value url : refs) {
            LdapURL ldapUrl = new LdapURL(url.getString());
            DN urlDn = (DN)ldapUrl.getDn().addAll(childDn);
            ldapUrl.setDn(urlDn);
            urls.add(ldapUrl.toString());
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingName(childDn);
        lre.setResolvedName(parentEntry.getDn());
        lre.setResolvedObj(parentEntry);
        return lre;
    }

    private LdapReferralException buildReferralExceptionForSearch(ServerEntry parentEntry, DN childDn, SearchScope scope) throws NamingException, LdapURLEncodingException {
        EntryAttribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        for (Value url : refs) {
            try {
                LdapURL ldapUrl = new LdapURL(url.getString());
                StringBuilder urlString = new StringBuilder();
                if (ldapUrl.getDn() == null || ldapUrl.getDn() == DN.EMPTY_DN) {
                    ldapUrl.setDn(parentEntry.getDn());
                } else {
                    DN urlDn = (DN)ldapUrl.getDn().addAll(childDn);
                    ldapUrl.setDn(urlDn);
                }
                urlString.append(ldapUrl.toString()).append("??");
                switch (scope) {
                    case OBJECT: {
                        urlString.append("base");
                        break;
                    }
                    case SUBTREE: {
                        urlString.append("sub");
                        break;
                    }
                    case ONELEVEL: {
                        urlString.append("one");
                    }
                }
                urls.add(urlString.toString());
            }
            catch (LdapURLEncodingException luee) {
                urls.add(url.getString());
            }
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingName(childDn);
        lre.setResolvedName(parentEntry.getDn());
        lre.setResolvedObj(parentEntry);
        return lre;
    }

    private PartialResultException buildPartialResultException(DN childDn) {
        PartialResultException pre = new PartialResultException(I18n.err(I18n.ERR_315, new Object[0]));
        pre.setRemainingName(childDn);
        pre.setResolvedName(DN.EMPTY_DN);
        return pre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddOperationContext opContext) throws Exception {
        LOG.debug(">> AddOperation : {}", opContext);
        LOG_CHANGES.debug(">> AddOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dn = opContext.getDn();
            dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            this.directoryService.getReferralManager().lockRead();
            if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                ServerEntry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
                DN childDn = (DN)dn.getSuffix(parentEntry.getDn().size());
                if (opContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    PartialResultException exception = this.buildPartialResultException(childDn);
                    throw exception;
                }
                this.directoryService.getReferralManager().unlock();
                LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                throw exception;
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.add(opContext);
        }
        finally {
            this.pop();
        }
        LOG.debug("<< AddOperation successful");
        LOG_CHANGES.debug("<< AddOperation successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(BindOperationContext opContext) throws Exception {
        LOG.debug(">> BindOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().bind(opContext);
        }
        finally {
            this.pop();
            LOG.debug("<< BindOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compare(CompareOperationContext opContext) throws Exception {
        LOG.debug(">> CompareOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dn = opContext.getDn();
            dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            this.directoryService.getReferralManager().lockRead();
            ServerEntry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                DN childDn = (DN)dn.getSuffix(parentEntry.getDn().size());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        PartialResultException exception = this.buildPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            boolean bl = interceptorChain.compare(opContext);
            return bl;
        }
        finally {
            this.pop();
            LOG.debug("<< CompareOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteOperationContext opContext) throws Exception {
        LOG.debug(">> DeleteOperation : {}", opContext);
        LOG_CHANGES.debug(">> DeleteOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dn = opContext.getDn();
            dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            this.directoryService.getReferralManager().lockRead();
            ServerEntry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                DN childDn = (DN)dn.getSuffix(parentEntry.getDn().size());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        PartialResultException exception = this.buildPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.delete(opContext);
        }
        finally {
            this.pop();
        }
        LOG.debug("<< DeleteOperation successful");
        LOG_CHANGES.debug("<< DeleteOperation successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DN getMatchedName(GetMatchedNameOperationContext opContext) throws Exception {
        LOG.debug(">> GetMatchedNameOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dN = this.directoryService.getInterceptorChain().getMatchedName(opContext);
            return dN;
        }
        finally {
            this.pop();
            LOG.debug("<< GetMatchedNameOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClonedServerEntry getRootDSE(GetRootDSEOperationContext opContext) throws Exception {
        LOG.debug(">> GetRootDSEOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            ClonedServerEntry clonedServerEntry = this.directoryService.getInterceptorChain().getRootDSE(opContext);
            return clonedServerEntry;
        }
        finally {
            this.pop();
            LOG.debug("<< getRootDSEOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DN getSuffix(GetSuffixOperationContext opContext) throws Exception {
        LOG.debug(">> GetSuffixOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dN = this.directoryService.getInterceptorChain().getSuffix(opContext);
            return dN;
        }
        finally {
            this.pop();
            LOG.debug("<< GetSuffixOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEntry(EntryOperationContext opContext) throws Exception {
        LOG.debug(">> hasEntryOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            boolean bl = this.directoryService.getInterceptorChain().hasEntry(opContext);
            return bl;
        }
        finally {
            this.pop();
            LOG.debug("<< HasEntryOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
        LOG.debug(">> ListOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            EntryFilteringCursor entryFilteringCursor = this.directoryService.getInterceptorChain().list(opContext);
            return entryFilteringCursor;
        }
        finally {
            this.pop();
            LOG.debug("<< ListOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listSuffixes(ListSuffixOperationContext opContext) throws Exception {
        LOG.debug(">> ListSuffixesOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            Set<String> set = this.directoryService.getInterceptorChain().listSuffixes(opContext);
            return set;
        }
        finally {
            this.pop();
            LOG.debug("<< ListSuffixesOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        LOG.debug(">> LookupOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            ClonedServerEntry clonedServerEntry = this.directoryService.getInterceptorChain().lookup(opContext);
            return clonedServerEntry;
        }
        finally {
            this.pop();
            LOG.debug("<< LookupOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ModifyOperationContext opContext) throws Exception {
        LOG.debug(">> ModifyOperation : {}", opContext);
        LOG_CHANGES.debug(">> ModifyOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dn = opContext.getDn();
            dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            this.directoryService.getReferralManager().lockRead();
            ServerEntry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                DN childDn = (DN)dn.getSuffix(parentEntry.getDn().size());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        PartialResultException exception = this.buildPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.modify(opContext);
        }
        finally {
            this.pop();
            LOG.debug("<< ModifyOperation successful");
            LOG_CHANGES.debug("<< ModifyOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(MoveOperationContext opContext) throws Exception {
        LOG.debug(">> MoveOperation : {}", opContext);
        LOG_CHANGES.debug(">> MoveOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dn = opContext.getDn();
            dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            this.directoryService.getReferralManager().lockRead();
            ServerEntry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                DN childDn = (DN)dn.getSuffix(parentEntry.getDn().size());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        PartialResultException exception = this.buildPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            DN parentDn = opContext.getParent();
            parentDn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            if (this.directoryService.getReferralManager().isReferral(parentDn) || this.directoryService.getReferralManager().hasParentReferral(parentDn)) {
                this.directoryService.getReferralManager().unlock();
                LdapNamingException exception = new LdapNamingException(ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                exception.setRemainingName(dn);
                throw exception;
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.move(opContext);
        }
        finally {
            this.pop();
            LOG.debug("<< MoveOperation successful");
            LOG_CHANGES.debug("<< MoveOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws Exception {
        LOG.debug(">> MoveAndRenameOperation : {}", opContext);
        LOG_CHANGES.debug(">> MoveAndRenameOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dn = opContext.getDn();
            dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            this.directoryService.getReferralManager().lockRead();
            ServerEntry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                DN childDn = (DN)dn.getSuffix(parentEntry.getDn().size());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        PartialResultException exception = this.buildPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            DN parentDn = opContext.getParent();
            parentDn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            if (this.directoryService.getReferralManager().isReferral(parentDn) || this.directoryService.getReferralManager().hasParentReferral(parentDn)) {
                this.directoryService.getReferralManager().unlock();
                LdapNamingException exception = new LdapNamingException(ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                exception.setRemainingName(dn);
                throw exception;
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.moveAndRename(opContext);
        }
        finally {
            this.pop();
            LOG.debug("<< MoveAndRenameOperation successful");
            LOG_CHANGES.debug("<< MoveAndRenameOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(RenameOperationContext opContext) throws Exception {
        LOG.debug(">> RenameOperation : {}", opContext);
        LOG_CHANGES.debug(">> RenameOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dn = opContext.getDn();
            dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            if (!dn.isEmpty()) {
                DN newDn = (DN)dn.clone();
                newDn.remove(dn.size() - 1);
                newDn.add(opContext.getNewRdn());
                opContext.setNewDn(newDn);
            }
            this.directoryService.getReferralManager().lockRead();
            ServerEntry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                DN childDn = (DN)dn.getSuffix(parentEntry.getDn().size());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        PartialResultException exception = this.buildPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.rename(opContext);
        }
        finally {
            this.pop();
            LOG.debug("<< RenameOperation successful");
            LOG_CHANGES.debug("<< RenameOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
        LOG.debug(">> SearchOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            DN dn = opContext.getDn();
            dn.normalize(this.directoryService.getSchemaManager().getNormalizerMapping());
            this.directoryService.getReferralManager().lockRead();
            ServerEntry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                DN childDn = (DN)dn.getSuffix(parentEntry.getDn().size());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralExceptionForSearch(parentEntry, childDn, opContext.getScope());
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (opContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        PartialResultException exception = this.buildPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralExceptionForSearch(parentEntry, childDn, opContext.getScope());
                    throw exception;
                }
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            EntryFilteringCursor entryFilteringCursor = interceptorChain.search(opContext);
            return entryFilteringCursor;
        }
        finally {
            this.pop();
            LOG.debug("<< SearchOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(UnbindOperationContext opContext) throws Exception {
        LOG.debug(">> UnbindOperation : {}", opContext);
        this.ensureStarted();
        this.push(opContext);
        try {
            this.directoryService.getInterceptorChain().unbind(opContext);
        }
        finally {
            this.pop();
        }
        LOG.debug("<< UnbindOperation successful");
    }

    private void ensureStarted() throws ServiceUnavailableException {
        if (!this.directoryService.isStarted()) {
            throw new ServiceUnavailableException(I18n.err(I18n.ERR_316, new Object[0]));
        }
    }

    private void pop() {
        InvocationStack stack = InvocationStack.getInstance();
        stack.pop();
    }

    private void push(OperationContext opContext) {
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(opContext);
    }
}

