/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.util.Comparator;
import org.apache.directory.server.core.avltree.AvlTreeMap;
import org.apache.directory.server.core.avltree.LinkedAvlMapNode;
import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;
import org.apache.directory.server.xdbm.AbstractTupleCursor;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlSingletonOrOrderedSetCursor<K, V>
extends AbstractTupleCursor<K, SingletonOrOrderedSet<V>> {
    private AvlTreeMap<K, V> tree;
    private LinkedAvlMapNode<K, V> node;
    private boolean onNode = false;
    private boolean isAfterLast = false;
    private boolean isBeforeFirst = true;
    private Tuple<K, SingletonOrOrderedSet<V>> returnedTuple = new Tuple();

    public AvlSingletonOrOrderedSetCursor(AvlTreeMap<K, V> tree) {
        this.tree = tree;
    }

    public Comparator<K> getKeyComparator() {
        return this.tree.getKeyComparator();
    }

    public Comparator<V> getValuComparator() {
        return this.tree.getValueComparator();
    }

    @Override
    public void after(Tuple<K, SingletonOrOrderedSet<V>> element) throws Exception {
        this.afterKey(element.getKey());
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast");
        this.node = this.tree.getLast();
        this.isBeforeFirst = false;
        this.isAfterLast = true;
        this.onNode = false;
    }

    @Override
    public boolean available() {
        return this.onNode;
    }

    @Override
    public void before(Tuple<K, SingletonOrOrderedSet<V>> element) throws Exception {
        this.beforeKey(element.getKey());
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst");
        this.node = this.tree.getFirst();
        this.isBeforeFirst = true;
        this.isAfterLast = false;
        this.onNode = false;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first");
        this.node = this.tree.getFirst();
        this.isBeforeFirst = false;
        this.isAfterLast = false;
        this.onNode = this.node != null;
        return this.onNode;
    }

    @Override
    public Tuple<K, SingletonOrOrderedSet<V>> get() throws Exception {
        this.checkNotClosed("get");
        if (this.onNode) {
            this.returnedTuple.setKey(this.node.key);
            this.returnedTuple.setValue(this.node.value);
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean isElementReused() {
        return true;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last");
        this.node = this.tree.getLast();
        this.isBeforeFirst = false;
        this.isAfterLast = false;
        this.onNode = this.node != null;
        return this.onNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next");
        if (this.isBeforeFirst) {
            this.node = this.tree.getFirst();
            this.isBeforeFirst = false;
            this.isAfterLast = false;
            this.onNode = this.node != null;
            return this.onNode;
        }
        if (this.isAfterLast) {
            return false;
        }
        if (this.onNode) {
            if (this.node == null) {
                this.node = this.tree.getFirst();
                return true;
            }
            if (this.node.next == null) {
                this.onNode = false;
                this.isAfterLast = true;
                this.isBeforeFirst = false;
                return false;
            }
            this.node = this.node.next;
            return true;
        }
        if (this.node == null) return false;
        this.onNode = true;
        if (!true) return false;
        return true;
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous");
        if (this.isBeforeFirst) {
            return false;
        }
        if (this.isAfterLast) {
            this.node = this.tree.getLast();
            this.isBeforeFirst = false;
            this.isAfterLast = false;
            this.onNode = this.node != null;
            return this.onNode;
        }
        if (this.onNode) {
            if (this.node == null) {
                this.node = this.tree.getLast();
                return true;
            }
            if (this.node.previous == null) {
                this.onNode = false;
                this.isAfterLast = false;
                this.isBeforeFirst = true;
                return false;
            }
            this.node = this.node.previous;
            return true;
        }
        return false;
    }

    @Override
    public void afterKey(K key) throws Exception {
        this.checkNotClosed("afterKey");
        if (key == null) {
            this.afterLast();
            return;
        }
        LinkedAvlMapNode<K, V> found = this.tree.findGreater(key);
        if (found == null) {
            this.node = this.tree.getLast();
            this.onNode = false;
            this.isAfterLast = true;
            this.isBeforeFirst = false;
            return;
        }
        this.node = found;
        this.isAfterLast = false;
        this.isBeforeFirst = false;
        this.onNode = false;
    }

    @Override
    public void afterValue(K key, SingletonOrOrderedSet<V> value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }

    @Override
    public void beforeKey(K key) throws Exception {
        this.checkNotClosed("beforeKey");
        if (key == null) {
            this.beforeFirst();
            return;
        }
        LinkedAvlMapNode<K, V> found = this.tree.findLess(key);
        if (found == null) {
            this.node = this.tree.getFirst();
            this.isAfterLast = false;
            this.isBeforeFirst = true;
        } else {
            this.node = found.next;
            this.isAfterLast = false;
            this.isBeforeFirst = false;
        }
        this.onNode = false;
    }

    @Override
    public void beforeValue(K key, SingletonOrOrderedSet<V> value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }
}

