/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.AbstractEntry;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.DnSerializer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultServerEntry
extends AbstractEntry<AttributeType>
implements ServerEntry {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServerEntry.class);
    private static transient AttributeType OBJECT_CLASS_AT;
    private static transient Object MUTEX;
    private SchemaManager schemaManager;

    private AttributeType getAttributeType(String upId) throws NamingException {
        if (StringTools.isEmpty(StringTools.trim(upId))) {
            String message = I18n.err(I18n.ERR_98, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        return this.schemaManager.lookupAttributeTypeRegistry(upId);
    }

    public static String getUpId(String upId, AttributeType attributeType) {
        String normUpId = StringTools.trim(upId);
        if (attributeType == null) {
            if (StringTools.isEmpty(normUpId)) {
                String message = I18n.err(I18n.ERR_99, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (StringTools.isEmpty(normUpId) && StringTools.isEmpty(upId = attributeType.getName())) {
            upId = attributeType.getOid();
        }
        return upId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initObjectClassAT(SchemaManager schemaManager) {
        block5: {
            try {
                if (OBJECT_CLASS_AT != null) break block5;
                Object object = MUTEX;
                synchronized (object) {
                    OBJECT_CLASS_AT = schemaManager.lookupAttributeTypeRegistry("objectClass");
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private void createAttribute(String upId, AttributeType attributeType, byte[] ... values) {
        DefaultServerAttribute attribute = new DefaultServerAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType, attribute);
    }

    private void createAttribute(String upId, AttributeType attributeType, String ... values) {
        DefaultServerAttribute attribute = new DefaultServerAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType, attribute);
    }

    private void createAttribute(String upId, AttributeType attributeType, Value<?> ... values) {
        DefaultServerAttribute attribute = new DefaultServerAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType, attribute);
    }

    DefaultServerEntry() {
        this.schemaManager = null;
        this.dn = DN.EMPTY_DN;
    }

    public DefaultServerEntry(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.dn = DN.EMPTY_DN;
        this.initObjectClassAT(schemaManager);
    }

    public DefaultServerEntry(SchemaManager schemaManager, Entry entry) {
        this.schemaManager = schemaManager;
        this.initObjectClassAT(schemaManager);
        this.dn = entry.getDn() != null ? (DN)entry.getDn().clone() : DN.EMPTY_DN;
        if (!this.dn.isNormalized()) {
            try {
                this.dn.normalize(schemaManager.getNormalizerMapping());
            }
            catch (NamingException ne) {
                LOG.warn("The DN '" + entry.getDn() + "' cannot be normalized");
            }
        }
        this.attributes = new HashMap(entry.size());
        for (EntryAttribute attribute : entry) {
            try {
                AttributeType attributeType = null;
                attributeType = attribute instanceof ServerAttribute ? ((ServerAttribute)attribute).getAttributeType() : schemaManager.lookupAttributeTypeRegistry(attribute.getId());
                DefaultServerAttribute serverAttribute = new DefaultServerAttribute(attributeType, attribute);
                this.add(serverAttribute);
            }
            catch (NamingException ne) {
                LOG.warn("The attribute '" + attribute.getId() + "' cannot be stored");
            }
        }
    }

    public DefaultServerEntry(SchemaManager schemaManager, DN dn) {
        if (dn == null) {
            dn = DN.EMPTY_DN;
        } else {
            this.dn = dn;
        }
        this.schemaManager = schemaManager;
        this.initObjectClassAT(schemaManager);
    }

    public DefaultServerEntry(SchemaManager schemaManager, DN dn, AttributeType ... attributeTypes) {
        if (dn == null) {
            dn = DN.EMPTY_DN;
        } else {
            this.dn = dn;
        }
        this.schemaManager = schemaManager;
        this.initObjectClassAT(schemaManager);
        this.set(attributeTypes);
    }

    public DefaultServerEntry(SchemaManager schemaManager, DN dn, AttributeType attributeType, String upId) {
        if (dn == null) {
            dn = DN.EMPTY_DN;
        } else {
            this.dn = dn;
        }
        this.schemaManager = schemaManager;
        this.initObjectClassAT(schemaManager);
        try {
            this.put(upId, attributeType, new String[]{null});
        }
        catch (NamingException ne) {
            LOG.error(I18n.err(I18n.ERR_100, upId, ne.getLocalizedMessage()));
        }
    }

    public DefaultServerEntry(SchemaManager schemaManager, DN dn, String ... upIds) {
        if (dn == null) {
            dn = DN.EMPTY_DN;
        } else {
            this.dn = dn;
        }
        this.schemaManager = schemaManager;
        this.initObjectClassAT(schemaManager);
        this.set(upIds);
    }

    public DefaultServerEntry(SchemaManager schemaManager, DN dn, ServerAttribute ... attributes) {
        if (dn == null) {
            dn = DN.EMPTY_DN;
        } else {
            this.dn = dn;
        }
        this.schemaManager = schemaManager;
        this.initObjectClassAT(schemaManager);
        for (ServerAttribute attribute : attributes) {
            try {
                this.put(attribute);
            }
            catch (NamingException ne) {
                LOG.warn("The ServerAttribute '{}' does not exist. It has been discarded", attribute);
            }
        }
    }

    @Override
    public void add(AttributeType attributeType, byte[] ... values) throws NamingException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_101, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (attributeType.equals(OBJECT_CLASS_AT)) {
            String message = I18n.err(I18n.ERR_102, new Object[0]);
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(AttributeType attributeType, String ... values) throws NamingException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_101, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(AttributeType attributeType, Value<?> ... values) throws NamingException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_101, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(EntryAttribute ... attributes) throws NamingException {
        for (EntryAttribute attribute : attributes) {
            ServerAttribute serverAttribute = (ServerAttribute)attribute;
            AttributeType attributeType = serverAttribute.getAttributeType();
            if (this.attributes.containsKey(attributeType)) {
                EntryAttribute oldAttribute = (EntryAttribute)this.attributes.get(attributeType);
                for (Value value : serverAttribute) {
                    oldAttribute.add(value);
                }
                oldAttribute.setUpId(serverAttribute.getUpId());
                continue;
            }
            this.attributes.put(attributeType, attribute);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, byte[] ... values) throws NamingException {
        if (attributeType.equals(OBJECT_CLASS_AT)) {
            String message = I18n.err(I18n.ERR_102, new Object[0]);
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        ServerAttribute attribute = (ServerAttribute)this.attributes.get(attributeType);
        upId = DefaultServerEntry.getUpId(upId, attributeType);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId, attributeType);
        } else {
            this.createAttribute(upId, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, Value<?> ... values) throws NamingException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_101, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        upId = DefaultServerEntry.getUpId(upId, attributeType);
        ServerAttribute attribute = (ServerAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId, attributeType);
        } else {
            this.createAttribute(upId, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, String ... values) throws NamingException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_101, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        upId = DefaultServerEntry.getUpId(upId, attributeType);
        ServerAttribute attribute = (ServerAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId, attributeType);
        } else {
            this.createAttribute(upId, attributeType, values);
        }
    }

    @Override
    public void add(String upId, byte[] ... values) throws NamingException {
        this.add(upId, this.getAttributeType(upId), values);
    }

    @Override
    public void add(String upId, String ... values) throws NamingException {
        this.add(upId, this.getAttributeType(upId), values);
    }

    @Override
    public void add(String upId, Value<?> ... values) throws NamingException {
        this.add(upId, this.getAttributeType(upId), values);
    }

    @Override
    public boolean contains(AttributeType attributeType, byte[] ... values) {
        if (attributeType == null) {
            return false;
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(AttributeType attributeType, String ... values) {
        if (attributeType == null) {
            return false;
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(AttributeType attributeType, Value<?> ... values) {
        if (attributeType == null) {
            return false;
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(EntryAttribute ... attributes) throws NamingException {
        for (EntryAttribute entryAttribute : attributes) {
            if (entryAttribute == null) {
                return this.attributes.size() == 0;
            }
            if (this.attributes.containsKey(((ServerAttribute)entryAttribute).getAttributeType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(String id, byte[] ... values) {
        if (id == null) {
            return false;
        }
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(id);
            if (attributeType == null) {
                return false;
            }
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute != null) {
                return attribute.contains(values);
            }
            return false;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    @Override
    public boolean contains(String id, String ... values) {
        if (id == null) {
            return false;
        }
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(id);
            if (attributeType == null) {
                return false;
            }
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute != null) {
                return attribute.contains(values);
            }
            return false;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    @Override
    public boolean contains(String id, Value<?> ... values) {
        if (id == null) {
            return false;
        }
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(id);
            if (attributeType == null) {
                return false;
            }
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute != null) {
                return attribute.contains(values);
            }
            return false;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    @Override
    public boolean containsAttribute(AttributeType attributeType) {
        return this.attributes.containsKey(attributeType);
    }

    @Override
    public boolean containsAttribute(String ... attributes) {
        for (String attribute : attributes) {
            try {
                if (this.attributes.containsKey(this.getAttributeType(attribute))) continue;
                return false;
            }
            catch (NamingException ne) {
                return false;
            }
        }
        return true;
    }

    @Override
    public EntryAttribute get(AttributeType attributeType) {
        return (EntryAttribute)this.attributes.get(attributeType);
    }

    @Override
    public EntryAttribute get(String alias) {
        try {
            return this.get(this.schemaManager.lookupAttributeTypeRegistry(StringTools.trim(StringTools.toLowerCase(alias))));
        }
        catch (NamingException ne) {
            String message = ne.getLocalizedMessage();
            LOG.error(message);
            return null;
        }
    }

    @Override
    public Set<AttributeType> getAttributeTypes() {
        return this.attributes.keySet();
    }

    @Override
    public boolean hasObjectClass(String objectClass) {
        return this.contains(OBJECT_CLASS_AT, objectClass);
    }

    @Override
    public boolean hasObjectClass(EntryAttribute objectClass) {
        if (objectClass == null) {
            return false;
        }
        if (!((ServerAttribute)objectClass).getAttributeType().equals(OBJECT_CLASS_AT)) {
            return false;
        }
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(OBJECT_CLASS_AT);
        if (attribute == null) {
            return false;
        }
        for (Value value : objectClass) {
            if (attribute.contains(value.getString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isValid(EntryAttribute objectClass) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isValid(String objectClass) {
        throw new NotImplementedException();
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, byte[] ... values) throws NamingException {
        return this.put(null, attributeType, values);
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, String ... values) throws NamingException {
        return this.put(null, attributeType, values);
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, Value<?> ... values) throws NamingException {
        return this.put(null, attributeType, values);
    }

    @Override
    public List<EntryAttribute> put(EntryAttribute ... attributes) throws NamingException {
        ArrayList<EntryAttribute> previous = new ArrayList<EntryAttribute>();
        for (EntryAttribute serverAttribute : attributes) {
            if (serverAttribute == null) {
                String message = I18n.err(I18n.ERR_103, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            EntryAttribute removed = this.attributes.put(((ServerAttribute)serverAttribute).getAttributeType(), serverAttribute);
            if (removed == null) continue;
            previous.add(removed);
        }
        return previous;
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, byte[] ... values) throws NamingException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_101, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (!StringTools.isEmpty(upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = I18n.err(I18n.ERR_104, upId, attributeType);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = DefaultServerEntry.getUpId(upId, attributeType);
        }
        if (attributeType.equals(OBJECT_CLASS_AT)) {
            String message = I18n.err(I18n.ERR_102, new Object[0]);
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        DefaultServerAttribute attribute = new DefaultServerAttribute(upId, attributeType, values);
        return this.attributes.put(attributeType, attribute);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, String ... values) throws NamingException {
        if (attributeType == null) {
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (IllegalArgumentException iae) {
                String message = I18n.err(I18n.ERR_101, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (!StringTools.isEmpty(upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = I18n.err(I18n.ERR_104, upId, attributeType);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = DefaultServerEntry.getUpId(upId, attributeType);
        }
        DefaultServerAttribute attribute = new DefaultServerAttribute(upId, attributeType, values);
        return this.attributes.put(attributeType, attribute);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, Value<?> ... values) throws NamingException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_101, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (!StringTools.isEmpty(upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = I18n.err(I18n.ERR_104, upId, attributeType);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = DefaultServerEntry.getUpId(upId, attributeType);
        }
        DefaultServerAttribute attribute = new DefaultServerAttribute(upId, attributeType, values);
        return this.attributes.put(attributeType, attribute);
    }

    @Override
    public EntryAttribute put(String upId, byte[] ... values) {
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (NamingException ne) {
            String message = I18n.err(I18n.ERR_105, upId, ne.getLocalizedMessage());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public EntryAttribute put(String upId, String ... values) {
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (NamingException ne) {
            String message = I18n.err(I18n.ERR_105, upId, ne.getLocalizedMessage());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public EntryAttribute put(String upId, Value<?> ... values) {
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (NamingException ne) {
            String message = I18n.err(I18n.ERR_105, upId, ne.getLocalizedMessage());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, byte[] ... values) throws NamingException {
        try {
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_106, attributeType));
            return false;
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, String ... values) throws NamingException {
        try {
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_106, attributeType));
            return false;
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, Value<?> ... values) throws NamingException {
        try {
            EntryAttribute attribute = (EntryAttribute)this.attributes.get(attributeType);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_106, attributeType));
            return false;
        }
    }

    @Override
    public List<EntryAttribute> remove(EntryAttribute ... attributes) throws NamingException {
        ArrayList<EntryAttribute> removedAttributes = new ArrayList<EntryAttribute>();
        for (EntryAttribute serverAttribute : attributes) {
            if (!this.attributes.containsKey(((ServerAttribute)serverAttribute).getAttributeType())) continue;
            this.attributes.remove(((ServerAttribute)serverAttribute).getAttributeType());
            removedAttributes.add(serverAttribute);
        }
        return removedAttributes;
    }

    @Override
    public boolean remove(String upId, byte[] ... values) throws NamingException {
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (NamingException ne) {
            LOG.error(I18n.err(I18n.ERR_106, upId));
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_107, upId));
            return false;
        }
    }

    @Override
    public boolean remove(String upId, String ... values) throws NamingException {
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (NamingException ne) {
            LOG.error(I18n.err(I18n.ERR_106, upId));
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_107, upId));
            return false;
        }
    }

    @Override
    public boolean remove(String upId, Value<?> ... values) throws NamingException {
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (NamingException ne) {
            LOG.error(I18n.err(I18n.ERR_106, upId));
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_107, upId));
            return false;
        }
    }

    @Override
    public List<EntryAttribute> removeAttributes(AttributeType ... attributes) {
        if (attributes.length == 0) {
            return null;
        }
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>(attributes.length);
        for (AttributeType attributeType : attributes) {
            EntryAttribute attr = (EntryAttribute)this.attributes.remove(attributeType);
            if (attr == null) continue;
            removed.add(attr);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public List<EntryAttribute> removeAttributes(String ... attributes) {
        if (attributes.length == 0) {
            return null;
        }
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>(attributes.length);
        for (String attribute : attributes) {
            AttributeType attributeType = null;
            try {
                attributeType = this.schemaManager.lookupAttributeTypeRegistry(attribute);
            }
            catch (NamingException ne) {
                String message = "The attribute '" + attribute + "' does not exist in the entry";
                LOG.warn(message);
                continue;
            }
            EntryAttribute attr = (EntryAttribute)this.attributes.remove(attributeType);
            if (attr == null) continue;
            removed.add(attr);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public List<EntryAttribute> set(AttributeType ... attributeTypes) {
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>();
        for (AttributeType attributeType : attributeTypes) {
            if (attributeType == null) {
                String message = I18n.err(I18n.ERR_108, new Object[0]);
                LOG.error(message);
                continue;
            }
            EntryAttribute attribute = this.attributes.put(attributeType, new DefaultServerAttribute(attributeType));
            if (attribute == null) continue;
            removed.add(attribute);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public List<EntryAttribute> set(String ... upIds) {
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>();
        for (String upId : upIds) {
            AttributeType attributeType = null;
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (NamingException ne) {
                LOG.warn("Trying to add a bad attribute type '{}', error : ", (Object)upId, (Object)ne.getLocalizedMessage());
                continue;
            }
            catch (IllegalArgumentException iae) {
                LOG.warn("Trying to add a bad attribute type '{}', error : ", (Object)upId, (Object)iae.getLocalizedMessage());
                continue;
            }
            EntryAttribute attribute = this.attributes.put(attributeType, new DefaultServerAttribute(upId, attributeType));
            if (attribute == null) continue;
            removed.add(attribute);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public Entry toClientEntry() throws NamingException {
        DefaultClientEntry clientEntry = new DefaultClientEntry(this.dn);
        for (EntryAttribute serverAttribute : this) {
            EntryAttribute clientAttribute = ((ServerAttribute)serverAttribute).toClientAttribute();
            clientEntry.add(clientAttribute);
        }
        return clientEntry;
    }

    @Override
    public Entry clone() {
        DefaultServerEntry clone = (DefaultServerEntry)super.clone();
        if (this.dn != null) {
            clone.dn = (DN)this.dn.clone();
        }
        clone.attributes = (Map)((HashMap)this.attributes).clone();
        clone.attributes.clear();
        for (EntryAttribute entryAttribute : this.attributes.values()) {
            ServerAttribute value = (ServerAttribute)entryAttribute.clone();
            clone.attributes.put(value.getAttributeType(), value);
        }
        return clone;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException(I18n.err(I18n.ERR_456, new Object[0]));
    }

    public void serialize(ObjectOutput out) throws IOException {
        DnSerializer.serialize(this.dn, out);
        out.writeInt(this.attributes.size());
        for (AttributeType attributeType : this.attributes.keySet()) {
            String oid = attributeType.getOid();
            out.writeUTF(oid);
            DefaultServerAttribute attribute = (DefaultServerAttribute)this.attributes.get(attributeType);
            attribute.serialize(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException(I18n.err(I18n.ERR_455, new Object[0]));
    }

    public void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dn = DnSerializer.deserialize(in);
        int nbAttributes = in.readInt();
        for (int i = 0; i < nbAttributes; ++i) {
            String oid = in.readUTF();
            try {
                AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
                DefaultServerAttribute attribute = new DefaultServerAttribute(attributeType);
                attribute.deserialize(in);
                this.attributes.put(attributeType, attribute);
                continue;
            }
            catch (NamingException ne) {
                LOG.warn(I18n.err(I18n.ERR_460, oid));
            }
        }
    }

    public int hashCode() {
        int result = 37;
        result = result * 17 + this.dn.hashCode();
        for (EntryAttribute attribute : this.attributes.values()) {
            result = result * 17 + attribute.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultServerEntry)) {
            return false;
        }
        DefaultServerEntry other = (DefaultServerEntry)o;
        if (this.dn == null ? other.getDn() != null : !this.dn.equals(other.getDn())) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (EntryAttribute attribute : other) {
            EntryAttribute attr = (EntryAttribute)this.attributes.get(((ServerAttribute)attribute).getAttributeType());
            if (attr == null) {
                return false;
            }
            if (attribute.equals(attr)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServerEntry\n");
        sb.append("    dn");
        if (this.dn.isNormalized()) {
            sb.append("[n]: ");
            sb.append(this.dn.getName());
        } else {
            sb.append("[]: ");
            sb.append(this.dn);
        }
        sb.append('\n');
        if (this.containsAttribute(OBJECT_CLASS_AT)) {
            EntryAttribute objectClass = this.get(OBJECT_CLASS_AT);
            sb.append(objectClass);
        }
        if (this.attributes.size() != 0) {
            for (EntryAttribute attribute : this.attributes.values()) {
                if (((ServerAttribute)attribute).getAttributeType().equals(OBJECT_CLASS_AT)) continue;
                sb.append(attribute);
            }
        }
        return sb.toString();
    }

    static {
        MUTEX = new Object();
    }
}

