/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.EventService;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.server.core.event.ExpressionEvaluator;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.core.event.RegistrationEntry;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.normalization.FilterNormalizingVisitor;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.normalizers.ConcreteNameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.registries.OidRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(EventInterceptor.class);
    private List<RegistrationEntry> registrations = new CopyOnWriteArrayList<RegistrationEntry>();
    private DirectoryService ds;
    private FilterNormalizingVisitor filterNormalizer;
    private Evaluator evaluator;
    private ExecutorService executor;

    @Override
    public void init(DirectoryService ds) throws Exception {
        LOG.info("Initializing ...");
        super.init(ds);
        this.ds = ds;
        OidRegistry oidRegistry = ds.getSchemaManager().getGlobalOidRegistry();
        SchemaManager schemaManager = ds.getSchemaManager();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(schemaManager);
        this.filterNormalizer = new FilterNormalizingVisitor(ncn, schemaManager);
        this.evaluator = new ExpressionEvaluator(oidRegistry, schemaManager);
        this.executor = new ThreadPoolExecutor(1, 10, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100));
        this.ds.setEventService(new DefaultEventService());
        LOG.info("Initialization complete.");
    }

    private void fire(final OperationContext opContext, EventType type, final DirectoryListener listener) {
        switch (type) {
            case ADD: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryAdded((AddOperationContext)opContext);
                    }
                });
                break;
            }
            case DELETE: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryDeleted((DeleteOperationContext)opContext);
                    }
                });
                break;
            }
            case MODIFY: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryModified((ModifyOperationContext)opContext);
                    }
                });
                break;
            }
            case MOVE: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryMoved((MoveOperationContext)opContext);
                    }
                });
                break;
            }
            case RENAME: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryRenamed((RenameOperationContext)opContext);
                    }
                });
            }
        }
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext opContext) throws Exception {
        next.add(opContext);
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(opContext.getDn(), opContext.getEntry());
        if (selecting.isEmpty()) {
            return;
        }
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isAdd(registration.getCriteria().getEventMask())) continue;
            this.fire(opContext, EventType.ADD, registration.getListener());
        }
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(opContext.getDn(), opContext.getEntry());
        next.delete(opContext);
        if (selecting.isEmpty()) {
            return;
        }
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isDelete(registration.getCriteria().getEventMask())) continue;
            this.fire(opContext, EventType.DELETE, registration.getListener());
        }
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        ClonedServerEntry oriEntry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(opContext.getDn(), oriEntry);
        next.modify(opContext);
        if (selecting.isEmpty()) {
            return;
        }
        ClonedServerEntry alteredEntry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        opContext.setAlteredEntry(alteredEntry);
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isModify(registration.getCriteria().getEventMask())) continue;
            this.fire(opContext, EventType.MODIFY, registration.getListener());
        }
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
        ClonedServerEntry oriEntry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(opContext.getDn(), oriEntry);
        next.rename(opContext);
        if (selecting.isEmpty()) {
            return;
        }
        ClonedServerEntry alteredEntry = opContext.lookup(opContext.getNewDn(), ByPassConstants.LOOKUP_BYPASS);
        opContext.setAlteredEntry(alteredEntry);
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isRename(registration.getCriteria().getEventMask())) continue;
            this.fire(opContext, EventType.RENAME, registration.getListener());
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, final MoveAndRenameOperationContext opContext) throws Exception {
        ClonedServerEntry oriEntry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(opContext.getDn(), oriEntry);
        next.moveAndRename(opContext);
        if (selecting.isEmpty()) {
            return;
        }
        opContext.setAlteredEntry(opContext.lookup(opContext.getNewDn(), ByPassConstants.LOOKUP_BYPASS));
        for (final RegistrationEntry registration : selecting) {
            if (!EventType.isMoveAndRename(registration.getCriteria().getEventMask())) continue;
            this.executor.execute(new Runnable(){

                public void run() {
                    registration.getListener().entryMovedAndRenamed(opContext);
                }
            });
        }
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        ClonedServerEntry oriEntry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(opContext.getDn(), oriEntry);
        next.move(opContext);
        if (selecting.isEmpty()) {
            return;
        }
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isMove(registration.getCriteria().getEventMask())) continue;
            this.fire(opContext, EventType.MOVE, registration.getListener());
        }
    }

    List<RegistrationEntry> getSelectingRegistrations(DN name, ServerEntry entry) throws Exception {
        if (this.registrations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegistrationEntry> selecting = new ArrayList<RegistrationEntry>();
        for (RegistrationEntry registration : this.registrations) {
            NotificationCriteria criteria = registration.getCriteria();
            if (!this.evaluator.evaluate(criteria.getFilter(), criteria.getBase().toNormName(), entry)) continue;
            selecting.add(registration);
        }
        return selecting;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultEventService
    implements EventService {
        DefaultEventService() {
        }

        @Override
        public void addListener(DirectoryListener listener) {
            EventInterceptor.this.registrations.add(new RegistrationEntry(listener));
        }

        @Override
        public void addListener(DirectoryListener listener, NotificationCriteria criteria) throws Exception {
            criteria.getBase().normalize(EventInterceptor.this.ds.getSchemaManager().getNormalizerMapping());
            ExprNode result = (ExprNode)criteria.getFilter().accept(EventInterceptor.this.filterNormalizer);
            criteria.setFilter(result);
            EventInterceptor.this.registrations.add(new RegistrationEntry(listener, criteria));
        }

        @Override
        public void removeListener(DirectoryListener listener) {
            for (RegistrationEntry entry : EventInterceptor.this.registrations) {
                if (entry.getListener() != listener) continue;
                EventInterceptor.this.registrations.remove(entry);
            }
        }

        @Override
        public List<RegistrationEntry> getRegistrationEntries() {
            return Collections.unmodifiableList(EventInterceptor.this.registrations);
        }
    }
}

