/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.schema.ldif.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schema.loader.ldif.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.shared.ldap.util.ExceptionUtils;

public class DefaultDirectoryServiceFactory
implements DirectoryServiceFactory {
    private DirectoryService directoryService;
    public static final DirectoryServiceFactory DEFAULT = new DefaultDirectoryServiceFactory();

    DefaultDirectoryServiceFactory() {
        try {
            this.directoryService = new DefaultDirectoryService();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(String name) throws Exception {
        if (this.directoryService != null && this.directoryService.isStarted()) {
            return;
        }
        this.build(name);
    }

    private void buildWorkingDirectory(String name) {
        String workingDirectory = System.getProperty("workingDirectory");
        if (workingDirectory == null) {
            workingDirectory = System.getProperty("java.io.tmpdir") + "/server-work-" + name;
        }
        this.directoryService.setWorkingDirectory(new File(workingDirectory));
    }

    private void initSchema() throws Exception {
        SchemaPartition schemaPartition = this.directoryService.getSchemaService().getSchemaPartition();
        LdifPartition ldifPartition = new LdifPartition();
        String workingDirectory = this.directoryService.getWorkingDirectory().getPath();
        ldifPartition.setWorkingDirectory(workingDirectory + "/schema");
        File schemaRepository = new File(workingDirectory, "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(new File(workingDirectory));
        extractor.extractOrCopy();
        schemaPartition.setWrappedPartition(ldifPartition);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager(loader);
        this.directoryService.setSchemaManager(schemaManager);
        schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager(schemaManager);
        List<Throwable> errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err(I18n.ERR_317, ExceptionUtils.printErrors(errors)));
        }
    }

    private void initSystemPartition() throws Exception {
        JdbmPartition systemPartition = new JdbmPartition();
        systemPartition.setId("system");
        systemPartition.setCacheSize(500);
        systemPartition.setSuffix("ou=system");
        systemPartition.setSchemaManager(this.directoryService.getSchemaManager());
        systemPartition.setPartitionDir(new File(this.directoryService.getWorkingDirectory(), "system"));
        HashSet indexedAttrs = new HashSet();
        indexedAttrs.add(new JdbmIndex("objectClass"));
        systemPartition.setIndexedAttributes(indexedAttrs);
        this.directoryService.setSystemPartition(systemPartition);
    }

    public void initJdbmPartition(String name, String suffix) throws Exception {
        JdbmPartition partition = new JdbmPartition();
        partition.setId(name);
        partition.setSuffix(suffix);
        partition.setSchemaManager(this.directoryService.getSchemaManager());
        partition.setPartitionDir(new File(this.directoryService.getWorkingDirectory(), name));
        this.directoryService.addPartition(partition);
    }

    public void build(String name) throws Exception {
        this.directoryService.setInstanceId(name);
        this.buildWorkingDirectory(name);
        String workingDirectoryPath = this.directoryService.getWorkingDirectory().getPath();
        File workingDirectory = new File(workingDirectoryPath);
        FileUtils.deleteDirectory((File)workingDirectory);
        this.initSchema();
        this.initSystemPartition();
        this.directoryService.startup();
    }

    public DirectoryService getDirectoryService() throws Exception {
        return this.directoryService;
    }
}

