/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterNormalizingVisitor
implements FilterVisitor {
    private static final Logger log = LoggerFactory.getLogger(FilterNormalizingVisitor.class);
    private final NameComponentNormalizer ncn;
    private final SchemaManager schemaManager;
    private static final boolean[] FILTER_CHAR = new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public static boolean isFilterChar(char c) {
        return (c | 0x7F) == 127 && FILTER_CHAR[c & 0x7F];
    }

    public FilterNormalizingVisitor(NameComponentNormalizer ncn, SchemaManager schemaManager) {
        this.ncn = ncn;
        this.schemaManager = schemaManager;
    }

    private Value<?> normalizeValue(String attribute, Value<?> value) {
        try {
            Value<String> normalized = null;
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(attribute);
            normalized = attributeType.getSyntax().isHumanReadable() ? new ClientStringValue((String)this.ncn.normalizeByName(attribute, value.getString())) : (Value<String>)this.ncn.normalizeByName(attribute, value.getBytes());
            return normalized;
        }
        catch (NamingException ne) {
            log.warn("Failed to normalize filter value: {}", (Object)ne.getLocalizedMessage(), (Object)ne);
            return null;
        }
    }

    private ExprNode visitPresenceNode(PresenceNode node) throws NamingException {
        node.setAttribute(this.schemaManager.getAttributeTypeRegistry().getOidByName(node.getAttribute()));
        return node;
    }

    private ExprNode visitSimpleNode(SimpleNode node) throws NamingException {
        if (!this.ncn.isDefined(node.getAttribute())) {
            return null;
        }
        Value<?> normalized = this.normalizeValue(node.getAttribute(), node.getValue());
        if (normalized == null) {
            return null;
        }
        node.setAttribute(this.schemaManager.getAttributeTypeRegistry().getOidByName(node.getAttribute()));
        node.setValue(normalized);
        return node;
    }

    private ExprNode visitSubstringNode(SubstringNode node) throws NamingException {
        if (!this.ncn.isDefined(node.getAttribute())) {
            return null;
        }
        Value<?> normInitial = null;
        if (node.getInitial() != null && (normInitial = this.normalizeValue(node.getAttribute(), new ClientStringValue(node.getInitial()))) == null) {
            return null;
        }
        ArrayList<String> normAnys = null;
        if (node.getAny() != null && node.getAny().size() != 0) {
            normAnys = new ArrayList<String>(node.getAny().size());
            for (String any : node.getAny()) {
                Value<?> normAny = this.normalizeValue(node.getAttribute(), new ClientStringValue(any));
                if (normAny == null) continue;
                normAnys.add(normAny.getString());
            }
            if (normAnys.size() == 0) {
                return null;
            }
        }
        Value<?> normFinal = null;
        if (node.getFinal() != null && (normFinal = this.normalizeValue(node.getAttribute(), new ClientStringValue(node.getFinal()))) == null) {
            return null;
        }
        node.setAttribute(this.schemaManager.getAttributeTypeRegistry().getOidByName(node.getAttribute()));
        if (normInitial != null) {
            node.setInitial(normInitial.getString());
        } else {
            node.setInitial(null);
        }
        node.setAny(normAnys);
        if (normFinal != null) {
            node.setFinal(normFinal.getString());
        } else {
            node.setFinal(null);
        }
        return node;
    }

    private ExprNode visitExtensibleNode(ExtensibleNode node) throws NamingException {
        node.setAttribute(this.schemaManager.getAttributeTypeRegistry().getOidByName(node.getAttribute()));
        return node;
    }

    private ExprNode visitBranchNode(BranchNode node) {
        if (node instanceof NotNode) {
            ExprNode child = node.getFirstChild();
            ExprNode result = (ExprNode)this.visit(child);
            if (result == null) {
                return null;
            }
            if (result instanceof BranchNode) {
                ArrayList<ExprNode> newChildren = new ArrayList<ExprNode>(1);
                newChildren.add(result);
                node.setChildren(newChildren);
                return node;
            }
            if (result instanceof LeafNode) {
                ArrayList<ExprNode> newChildren = new ArrayList<ExprNode>(1);
                newChildren.add(result);
                node.setChildren(newChildren);
                return node;
            }
        } else {
            BranchNode branchNode = node;
            List<ExprNode> children = node.getChildren();
            ArrayList<ExprNode> newChildren = new ArrayList<ExprNode>(children.size());
            for (int i = 0; i < children.size(); ++i) {
                ExprNode child = children.get(i);
                ExprNode result = (ExprNode)this.visit(child);
                if (result == null) continue;
                newChildren.add(result);
            }
            if (branchNode instanceof AndNode && newChildren.size() != children.size()) {
                return null;
            }
            if (newChildren.size() == 0) {
                return null;
            }
            if (newChildren.size() == 1) {
                return (ExprNode)newChildren.get(0);
            }
            branchNode.setChildren(newChildren);
        }
        return node;
    }

    @Override
    public Object visit(ExprNode node) {
        try {
            if (node instanceof PresenceNode) {
                return this.visitPresenceNode((PresenceNode)node);
            }
            if (node instanceof BranchNode) {
                return this.visitBranchNode((BranchNode)node);
            }
            if (node instanceof SimpleNode) {
                return this.visitSimpleNode((SimpleNode)node);
            }
            if (node instanceof ExtensibleNode) {
                return this.visitExtensibleNode((ExtensibleNode)node);
            }
            if (node instanceof SubstringNode) {
                return this.visitSubstringNode((SubstringNode)node);
            }
            return null;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canVisit(ExprNode node) {
        return true;
    }

    @Override
    public boolean isPrefix() {
        return false;
    }

    @Override
    public List<ExprNode> getOrder(BranchNode node, List<ExprNode> children) {
        return children;
    }
}

