/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.CursorList;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.MultiException;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.cursor.SingletonCursor;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeIdentifierException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.apache.directory.shared.ldap.util.tree.DnBranchNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPartitionNexus
implements Partition,
PartitionNexus {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPartitionNexus.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final String ASF = "Apache Software Foundation";
    private final ServerEntry rootDSE;
    private DirectoryService directoryService;
    private SchemaManager schemaManager;
    private Map<String, Partition> partitions = new HashMap<String, Partition>();
    private DnBranchNode<Partition> partitionLookupTree = new DnBranchNode();
    private Partition system;
    private boolean initialized;

    public DefaultPartitionNexus(ServerEntry rootDSE) throws Exception {
        this.rootDSE = rootDSE;
        rootDSE.put("subschemaSubentry", "cn=schema");
        rootDSE.put("supportedLDAPVersion", "3");
        rootDSE.put("supportedFeatures", "1.3.6.1.4.1.4203.1.5.1");
        rootDSE.put("supportedExtension", "1.3.6.1.4.1.1466.20036");
        rootDSE.put("supportedControl", "2.16.840.1.113730.3.4.3", "2.16.840.1.113730.3.4.7", "1.3.6.1.4.1.4203.1.10.1", "2.16.840.1.113730.3.4.2", "1.3.6.1.4.1.18060.0.0.1", "1.2.840.113556.1.4.319", "1.3.6.1.4.1.4203.1.9.1.3", "1.3.6.1.4.1.4203.1.9.1.4", "1.3.6.1.4.1.4203.1.9.1.1", "1.3.6.1.4.1.4203.1.9.1.2");
        rootDSE.put("objectClass", "top", "extensibleObject");
        rootDSE.put("vendorName", ASF);
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            LOG.error(I18n.err(I18n.ERR_33, new Object[0]));
        }
        rootDSE.put("vendorVersion", props.getProperty("apacheds.version", "UNKNOWN"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        this.schemaManager = this.directoryService.getSchemaManager();
        DN adminDn = new DN("uid=admin,ou=system");
        adminDn.normalize(this.schemaManager.getNormalizerMapping());
        this.initializeSystemPartition(this.directoryService);
        ArrayList<Partition> initializedPartitions = new ArrayList<Partition>();
        initializedPartitions.add(0, this.system);
        try {
            for (Partition partition : this.directoryService.getPartitions()) {
                partition.setSchemaManager(this.schemaManager);
                DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), this.directoryService);
                AddContextPartitionOperationContext opCtx = new AddContextPartitionOperationContext((CoreSession)adminSession, partition);
                this.addContextPartition(opCtx);
                initializedPartitions.add(opCtx.getPartition());
            }
            this.initialized = true;
        }
        finally {
            if (!this.initialized) {
                Iterator i = initializedPartitions.iterator();
                while (i.hasNext()) {
                    Partition partition = (Partition)i.next();
                    i.remove();
                    try {
                        partition.destroy();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to destroy a partition: " + partition.getSuffixDn(), e);
                    }
                    finally {
                        this.unregister(partition);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Partition initializeSystemPartition(DirectoryService directoryService) throws Exception {
        String key;
        Partition override = directoryService.getSystemPartition();
        if (override != null) {
            if (!override.getId().equals("system")) {
                throw new ConfigurationException(I18n.err(I18n.ERR_262, override.getId()));
            }
            this.system = override;
        }
        this.system.initialize();
        DN systemSuffixDn = new DN("ou=system");
        systemSuffixDn.normalize(this.schemaManager.getNormalizerMapping());
        DefaultServerEntry systemEntry = new DefaultServerEntry(this.schemaManager, systemSuffixDn);
        systemEntry.put("objectClass", "top", "organizationalUnit", "extensibleObject");
        systemEntry.put("creatorsName", "uid=admin,ou=system");
        systemEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
        systemEntry.add("entryCSN", directoryService.getCSN().toString());
        systemEntry.add("entryUUID", UUID.randomUUID().toString());
        systemEntry.put(NamespaceTools.getRdnAttribute("ou=system"), NamespaceTools.getRdnValue("ou=system"));
        DN adminDn = new DN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(this.schemaManager.getNormalizerMapping());
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), directoryService);
        AddOperationContext addOperationContext = new AddOperationContext((CoreSession)adminSession, systemEntry);
        if (!this.system.hasEntry(new EntryOperationContext(adminSession, systemEntry.getDn()))) {
            this.system.add(addOperationContext);
        }
        if (this.partitions.containsKey(key = this.system.getSuffixDn().getName())) {
            throw new ConfigurationException(I18n.err(I18n.ERR_263, key));
        }
        DnBranchNode<Partition> dnBranchNode = this.partitionLookupTree;
        synchronized (dnBranchNode) {
            this.partitions.put(key, this.system);
            this.partitionLookupTree.add(this.system.getSuffixDn(), this.system);
            EntryAttribute namingContexts = this.rootDSE.get("namingContexts");
            if (namingContexts == null) {
                namingContexts = new DefaultServerAttribute(this.schemaManager.lookupAttributeTypeRegistry("namingContexts"), this.system.getSuffixDn().getName());
                this.rootDSE.put(namingContexts);
            } else {
                namingContexts.add(this.system.getSuffixDn().getName());
            }
        }
        return this.system;
    }

    @Override
    public synchronized void destroy() {
        if (!this.initialized) {
            return;
        }
        for (String suffix : new HashSet<String>(this.partitions.keySet())) {
            try {
                DN adminDn = new DN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
                adminDn.normalize(this.schemaManager.getNormalizerMapping());
                DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), this.directoryService);
                this.removeContextPartition(new RemoveContextPartitionOperationContext(adminSession, new DN(suffix)));
            }
            catch (Exception e) {
                LOG.warn("Failed to destroy a partition: " + suffix, e);
            }
        }
        this.initialized = false;
    }

    @Override
    public String getId() {
        return "NEXUS";
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_264, new Object[0]));
    }

    @Override
    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public DN getSuffixDn() {
        return DN.EMPTY_DN;
    }

    @Override
    public String getSuffix() {
        return "";
    }

    @Override
    public void setSuffix(String suffix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void sync() throws Exception {
        MultiException error = null;
        for (Partition partition : this.partitions.values()) {
            try {
                partition.sync();
            }
            catch (Exception e) {
                LOG.warn("Failed to flush partition data out.", e);
                if (error == null) {
                    error = new MultiException(I18n.err(I18n.ERR_265, new Object[0]));
                }
                error.addThrowable(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    @Override
    public void add(AddOperationContext addContext) throws Exception {
        Partition backend = this.getPartition(addContext.getDn());
        backend.add(addContext);
    }

    @Override
    public void bind(BindOperationContext bindContext) throws Exception {
        Partition partition = this.getPartition(bindContext.getDn());
        partition.bind(bindContext);
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws Exception {
        Partition partition = this.getPartition(compareContext.getDn());
        if (!this.schemaManager.getAttributeTypeRegistry().contains(compareContext.getOid())) {
            throw new LdapInvalidAttributeIdentifierException(I18n.err(I18n.ERR_266, compareContext.getOid()));
        }
        AttributeType attrType = this.schemaManager.lookupAttributeTypeRegistry(compareContext.getOid());
        EntryAttribute attr = partition.lookup(compareContext.newLookupContext(compareContext.getDn())).get(attrType.getName());
        if (attr == null) {
            throw new LdapNoSuchAttributeException();
        }
        if (attr.contains(compareContext.getValue())) {
            return true;
        }
        Normalizer normalizer = attrType.getEquality().getNormalizer();
        Value<?> reqVal = normalizer.normalize(compareContext.getValue());
        for (Value value : attr) {
            Value<?> attrValObj = normalizer.normalize(value);
            if (!attrValObj.equals(reqVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws Exception {
        Partition backend = this.getPartition(deleteContext.getDn());
        backend.delete(deleteContext);
    }

    @Override
    public boolean hasEntry(EntryOperationContext opContext) throws Exception {
        DN dn = opContext.getDn();
        if (IS_DEBUG) {
            LOG.debug("Check if DN '" + dn + "' exists.");
        }
        if (dn.size() == 0) {
            return true;
        }
        Partition backend = this.getPartition(dn);
        return backend.hasEntry(opContext);
    }

    @Override
    public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
        Partition backend = this.getPartition(opContext.getDn());
        return backend.list(opContext);
    }

    @Override
    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        DN dn = opContext.getDn();
        if (dn.size() == 0) {
            ClonedServerEntry retval = new ClonedServerEntry(this.rootDSE);
            Set<AttributeType> attributeTypes = this.rootDSE.getAttributeTypes();
            if (opContext.getAttrsId() != null && !opContext.getAttrsId().isEmpty()) {
                for (AttributeType attributeType : attributeTypes) {
                    String oid = attributeType.getOid();
                    if (opContext.getAttrsId().contains(oid)) continue;
                    retval.removeAttributes(attributeType);
                }
                return retval;
            }
            return new ClonedServerEntry(this.rootDSE);
        }
        Partition backend = this.getPartition(dn);
        return backend.lookup(opContext);
    }

    public ClonedServerEntry lookup(Long id) throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws Exception {
        if (modifyContext.getModItems().size() == 0) {
            return;
        }
        Partition backend = this.getPartition(modifyContext.getDn());
        backend.modify(modifyContext);
    }

    @Override
    public void move(MoveOperationContext opContext) throws Exception {
        Partition backend = this.getPartition(opContext.getDn());
        backend.move(opContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws Exception {
        Partition backend = this.getPartition(opContext.getDn());
        backend.moveAndRename(opContext);
    }

    @Override
    public void rename(RenameOperationContext opContext) throws Exception {
        Partition backend = this.getPartition(opContext.getDn());
        backend.rename(opContext);
    }

    private EntryFilteringCursor searchRootDSE(SearchOperationContext searchOperationContext) throws Exception {
        DefaultServerEntry serverEntry;
        SearchControls searchControls = searchOperationContext.getSearchControls();
        String[] ids = searchControls.getReturningAttributes();
        if (ids == null || ids.length == 0) {
            ServerEntry rootDSE = this.getRootDSE(null).clone();
            return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(rootDSE), searchOperationContext);
        }
        HashSet<String> realIds = new HashSet<String>();
        boolean allUserAttributes = searchOperationContext.isAllUserAttributes();
        boolean allOperationalAttributes = searchOperationContext.isAllOperationalAttributes();
        boolean noAttribute = searchOperationContext.isNoAttributes();
        for (String id : ids) {
            String idTrimmed = id.trim();
            try {
                realIds.add(this.schemaManager.getAttributeTypeRegistry().getOidByName(idTrimmed));
            }
            catch (Exception e) {
                realIds.add(idTrimmed);
            }
        }
        if (noAttribute) {
            serverEntry = new DefaultServerEntry(this.schemaManager, DN.EMPTY_DN);
            return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(serverEntry), searchOperationContext);
        }
        if (allUserAttributes && allOperationalAttributes) {
            ServerEntry rootDSE = this.getRootDSE(null).clone();
            return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(rootDSE), searchOperationContext);
        }
        serverEntry = new DefaultServerEntry(this.schemaManager, DN.EMPTY_DN);
        ClonedServerEntry rootDSE = this.getRootDSE(new GetRootDSEOperationContext(searchOperationContext.getSession()));
        for (EntryAttribute attribute : rootDSE) {
            AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(attribute.getUpId());
            if (realIds.contains(type.getOid())) {
                serverEntry.put(attribute);
                continue;
            }
            if (allUserAttributes && type.getUsage() == UsageEnum.USER_APPLICATIONS) {
                serverEntry.put(attribute);
                continue;
            }
            if (!allOperationalAttributes || type.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
            serverEntry.put(attribute);
        }
        return new BaseEntryFilteringCursor(new SingletonCursor<ServerEntry>(serverEntry), searchOperationContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
        DN base = opContext.getDn();
        SearchControls searchCtls = opContext.getSearchControls();
        ExprNode filter = opContext.getFilter();
        if (base.size() == 0) {
            boolean isObjectScope = searchCtls.getSearchScope() == 0;
            boolean isOnelevelScope = searchCtls.getSearchScope() == 1;
            boolean isSublevelScope = searchCtls.getSearchScope() == 2;
            boolean isSearchAll = false;
            if (filter instanceof PresenceNode) {
                isSearchAll = ((PresenceNode)filter).getAttribute().equals("2.5.4.0");
            }
            if (filter instanceof PresenceNode && isObjectScope && isSearchAll) {
                return this.searchRootDSE(opContext);
            }
            if (isObjectScope && !isSearchAll) {
                return new BaseEntryFilteringCursor(new EmptyCursor<ServerEntry>(), opContext);
            }
            if (isOnelevelScope) {
                ArrayList<EntryFilteringCursor> cursors = new ArrayList<EntryFilteringCursor>();
                for (Partition p : this.partitions.values()) {
                    opContext.setDn(p.getSuffixDn());
                    opContext.setScope(SearchScope.OBJECT);
                    cursors.add(p.search(opContext));
                }
                return new CursorList(cursors, opContext);
            }
            if (isSublevelScope) {
                ArrayList<EntryFilteringCursor> cursors = new ArrayList<EntryFilteringCursor>();
                for (Partition p : this.partitions.values()) {
                    ClonedServerEntry entry = p.lookup(new LookupOperationContext(this.directoryService.getAdminSession(), p.getSuffixDn()));
                    if (entry == null) continue;
                    Partition backend = this.getPartition(entry.getDn());
                    opContext.setDn(entry.getDn());
                    cursors.add(backend.search(opContext));
                }
                return new CursorList(cursors, opContext);
            }
            throw new LdapNameNotFoundException();
        }
        base.normalize(this.schemaManager.getNormalizerMapping());
        Partition backend = this.getPartition(base);
        return backend.search(opContext);
    }

    @Override
    public void unbind(UnbindOperationContext unbindContext) throws Exception {
        Partition partition = this.getPartition(unbindContext.getDn());
        partition.unbind(unbindContext);
    }

    @Override
    public ClonedServerEntry getRootDSE(GetRootDSEOperationContext getRootDSEContext) {
        return new ClonedServerEntry(this.rootDSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addContextPartition(AddContextPartitionOperationContext opContext) throws Exception {
        Partition partition = opContext.getPartition();
        String key = partition.getSuffixDn().getNormName();
        if (this.partitions.containsKey(key)) {
            throw new ConfigurationException(I18n.err(I18n.ERR_263, key));
        }
        if (!partition.isInitialized()) {
            partition.initialize();
        }
        DnBranchNode<Partition> dnBranchNode = this.partitionLookupTree;
        synchronized (dnBranchNode) {
            DN partitionSuffix = partition.getSuffixDn();
            if (partitionSuffix == null) {
                throw new ConfigurationException(I18n.err(I18n.ERR_267, partition.getId()));
            }
            this.partitions.put(partitionSuffix.getNormName(), partition);
            this.partitionLookupTree.add(partition.getSuffixDn(), partition);
            EntryAttribute namingContexts = this.rootDSE.get("namingContexts");
            if (namingContexts == null) {
                namingContexts = new DefaultServerAttribute(this.schemaManager.lookupAttributeTypeRegistry("namingContexts"), partitionSuffix.getName());
                this.rootDSE.put(namingContexts);
            } else {
                namingContexts.add(partitionSuffix.getName());
            }
        }
    }

    @Override
    public synchronized void removeContextPartition(RemoveContextPartitionOperationContext removeContextPartition) throws Exception {
        String key = removeContextPartition.getDn().getNormName();
        Partition partition = this.partitions.get(key);
        if (partition == null) {
            String msg = I18n.err(I18n.ERR_34, key);
            LOG.error(msg);
            throw new NameNotFoundException(msg);
        }
        String partitionSuffix = partition.getSuffixDn().getName();
        EntryAttribute namingContexts = this.rootDSE.get("namingContexts");
        if (namingContexts != null) {
            if (namingContexts.contains(partitionSuffix)) {
                namingContexts.remove(partitionSuffix);
            } else {
                String msg = I18n.err(I18n.ERR_35, key);
                LOG.error(msg);
                throw new NameNotFoundException(msg);
            }
        }
        this.partitionLookupTree.remove(partition);
        this.partitions.remove(key);
        partition.destroy();
    }

    @Override
    public Partition getSystemPartition() {
        return this.system;
    }

    @Override
    public Partition getPartition(DN dn) throws Exception {
        Partition parent = this.partitionLookupTree.getParentElement(dn);
        if (parent == null) {
            throw new LdapNameNotFoundException(I18n.err(I18n.ERR_268, dn));
        }
        return parent;
    }

    @Override
    public DN getMatchedName(GetMatchedNameOperationContext matchedNameContext) throws Exception {
        DN dn = (DN)matchedNameContext.getDn().clone();
        while (dn.size() > 0) {
            if (this.hasEntry(new EntryOperationContext(matchedNameContext.getSession(), dn))) {
                return dn;
            }
            dn.remove(dn.size() - 1);
        }
        return dn;
    }

    @Override
    public DN getSuffix(GetSuffixOperationContext getSuffixContext) throws Exception {
        Partition backend = this.getPartition(getSuffixContext.getDn());
        return backend.getSuffixDn();
    }

    @Override
    public Set<String> listSuffixes(ListSuffixOperationContext emptyContext) throws Exception {
        return Collections.unmodifiableSet(this.partitions.keySet());
    }

    @Override
    public void registerSupportedExtensions(Set<String> extensionOids) throws Exception {
        EntryAttribute supportedExtension = this.rootDSE.get("supportedExtension");
        if (supportedExtension == null) {
            this.rootDSE.set("supportedExtension");
            supportedExtension = this.rootDSE.get("supportedExtension");
        }
        for (String extensionOid : extensionOids) {
            supportedExtension.add(extensionOid);
        }
    }

    @Override
    public void registerSupportedSaslMechanisms(Set<String> supportedSaslMechanisms) throws Exception {
        EntryAttribute supportedSaslMechanismsAttribute = this.rootDSE.get("supportedSASLMechanisms");
        if (supportedSaslMechanismsAttribute == null) {
            this.rootDSE.set("supportedSASLMechanisms");
            supportedSaslMechanismsAttribute = this.rootDSE.get("supportedSASLMechanisms");
        }
        for (String saslMechanism : supportedSaslMechanisms) {
            supportedSaslMechanismsAttribute.add(saslMechanism);
        }
    }

    private void unregister(Partition partition) throws Exception {
        EntryAttribute namingContexts = this.rootDSE.get("namingContexts");
        if (namingContexts != null) {
            namingContexts.remove(partition.getSuffixDn().getName());
        }
        this.partitions.remove(partition.getSuffixDn().getName());
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public void setDirectoryService(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }
}

