/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.referral;

import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.ReferralManager;
import org.apache.directory.server.core.ReferralManagerImpl;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferralInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ReferralInterceptor.class);
    private PartitionNexus nexus;
    private SchemaManager schemaManager;
    private ReferralManager referralManager;
    private String subschemaSubentryDnNorm;

    private static void checkRefAttributeValue(Value<?> value) throws NamingException, LdapURLEncodingException {
        ServerStringValue ref = (ServerStringValue)value;
        String refVal = ref.getString();
        LdapURL ldapUrl = new LdapURL(refVal);
        if (ldapUrl.getScope() != SearchScope.OBJECT) {
            String message = I18n.err(I18n.ERR_36, new Object[0]);
            LOG.error(message);
            throw new NamingException(message);
        }
        if (!StringTools.isEmpty(ldapUrl.getFilter())) {
            String message = I18n.err(I18n.ERR_37, new Object[0]);
            LOG.error(message);
            throw new NamingException(message);
        }
        if (ldapUrl.getAttributes() != null && ldapUrl.getAttributes().size() != 0) {
            String message = I18n.err(I18n.ERR_38, new Object[0]);
            LOG.error(message);
            throw new NamingException(message);
        }
        if (ldapUrl.getExtensions() != null && ldapUrl.getExtensions().size() != 0) {
            String message = I18n.err(I18n.ERR_39, new Object[0]);
            LOG.error(message);
            throw new NamingException(message);
        }
        if (ldapUrl.getExtensions() != null && ldapUrl.getExtensions().size() != 0) {
            String message = I18n.err(I18n.ERR_40, new Object[0]);
            LOG.error(message);
            throw new NamingException(message);
        }
        DN dn = ldapUrl.getDn();
        if (dn == null || dn.isEmpty()) {
            String message = I18n.err(I18n.ERR_41, new Object[0]);
            LOG.error(message);
            throw new NamingException(message);
        }
    }

    private static boolean isReferral(ServerEntry entry) throws NamingException {
        if (entry == null) {
            return false;
        }
        EntryAttribute oc = entry.get("objectClass");
        if (oc == null) {
            LOG.warn("could not find objectClass attribute in entry: " + entry);
            return false;
        }
        if (!oc.contains("referral")) {
            return false;
        }
        EntryAttribute refAttr = entry.get("ref");
        if (refAttr == null) {
            String message = I18n.err(I18n.ERR_42, new Object[0]);
            LOG.error(message);
            throw new NamingException(message);
        }
        for (Value value : refAttr) {
            try {
                ReferralInterceptor.checkRefAttributeValue(value);
            }
            catch (LdapURLEncodingException luee) {}
        }
        return true;
    }

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        this.nexus = directoryService.getPartitionNexus();
        this.schemaManager = directoryService.getSchemaManager();
        this.referralManager = new ReferralManagerImpl(directoryService);
        directoryService.setReferralManager(this.referralManager);
        Value<?> subschemaSubentry = this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        DN subschemaSubentryDn = new DN(subschemaSubentry.getString());
        subschemaSubentryDn.normalize(this.schemaManager.getNormalizerMapping());
        this.subschemaSubentryDnNorm = subschemaSubentryDn.getNormName();
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext opContext) throws Exception {
        ClonedServerEntry entry = opContext.getEntry();
        boolean isReferral = ReferralInterceptor.isReferral(entry);
        next.add(opContext);
        if (isReferral) {
            this.referralManager.lockWrite();
            this.referralManager.addReferral(entry);
            this.referralManager.unlock();
        }
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        ClonedServerEntry entry = opContext.getEntry();
        next.delete(opContext);
        if (entry != null && ReferralInterceptor.isReferral(entry)) {
            this.referralManager.lockWrite();
            this.referralManager.removeReferral(entry);
            this.referralManager.unlock();
        }
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        DN oldName = opContext.getDn();
        DN newName = (DN)opContext.getParent().clone();
        newName.add(oldName.get(oldName.size() - 1));
        boolean isReferral = ReferralInterceptor.isReferral(opContext.getEntry());
        next.move(opContext);
        if (isReferral) {
            LookupOperationContext lookupContext = new LookupOperationContext(opContext.getSession(), newName);
            ClonedServerEntry newEntry = this.nexus.lookup(lookupContext);
            this.referralManager.lockWrite();
            this.referralManager.addReferral(newEntry);
            this.referralManager.removeReferral(opContext.getEntry());
            this.referralManager.unlock();
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
        DN newName = (DN)opContext.getParent().clone();
        newName.add(opContext.getNewRdn());
        boolean isReferral = ReferralInterceptor.isReferral(opContext.getEntry());
        next.moveAndRename(opContext);
        if (isReferral) {
            LookupOperationContext lookupContext = new LookupOperationContext(opContext.getSession(), newName);
            ClonedServerEntry newEntry = this.nexus.lookup(lookupContext);
            this.referralManager.lockWrite();
            this.referralManager.addReferral(newEntry);
            this.referralManager.removeReferral(opContext.getEntry());
            this.referralManager.unlock();
        }
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
        boolean isReferral = ReferralInterceptor.isReferral(opContext.getEntry());
        next.rename(opContext);
        if (isReferral) {
            LookupOperationContext lookupContext = new LookupOperationContext(opContext.getSession(), opContext.getNewDn());
            ClonedServerEntry newEntry = this.nexus.lookup(lookupContext);
            this.referralManager.lockWrite();
            this.referralManager.addReferral(newEntry);
            this.referralManager.removeReferral(opContext.getEntry().getOriginalEntry());
            this.referralManager.unlock();
        }
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        DN name = opContext.getDn();
        next.modify(opContext);
        if (name == DN.EMPTY_DN || this.subschemaSubentryDnNorm.equals(name.getNormName())) {
            return;
        }
        LookupOperationContext lookupContext = new LookupOperationContext(opContext.getSession(), name);
        ClonedServerEntry newEntry = this.nexus.lookup(lookupContext);
        if (newEntry != null) {
            this.referralManager.lockWrite();
            if (this.referralManager.isReferral(newEntry.getDn())) {
                this.referralManager.removeReferral(opContext.getEntry());
                this.referralManager.addReferral(newEntry);
            }
            this.referralManager.unlock();
        }
    }
}

