/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.LdapSyntax;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.DITContentRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.DITStructureRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.LdapComparatorDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapComparatorDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleUseDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.NameFormDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescriptionSchemaParser;

public class DescriptionParsers {
    private static final LdapComparatorDescription[] EMPTY_COMPARATORS = new LdapComparatorDescription[0];
    private static final NormalizerDescription[] EMPTY_NORMALIZERS = new NormalizerDescription[0];
    private static final SyntaxCheckerDescription[] EMPTY_SYNTAX_CHECKERS = new SyntaxCheckerDescription[0];
    private static final LdapSyntax[] EMPTY_SYNTAXES = new LdapSyntax[0];
    private static final MatchingRule[] EMPTY_MATCHING_RULES = new MatchingRule[0];
    private static final AttributeType[] EMPTY_ATTRIBUTE_TYPES = new AttributeType[0];
    private static final ObjectClass[] EMPTY_OBJECT_CLASSES = new ObjectClass[0];
    private static final MatchingRuleUse[] EMPTY_MATCHING_RULE_USES = new MatchingRuleUse[0];
    private static final DITStructureRule[] EMPTY_DIT_STRUCTURE_RULES = new DITStructureRule[0];
    private static final DITContentRule[] EMPTY_DIT_CONTENT_RULES = new DITContentRule[0];
    private static final NameForm[] EMPTY_NAME_FORMS = new NameForm[0];
    private final LdapComparatorDescriptionSchemaParser comparatorParser = new LdapComparatorDescriptionSchemaParser();
    private final NormalizerDescriptionSchemaParser normalizerParser = new NormalizerDescriptionSchemaParser();
    private final SyntaxCheckerDescriptionSchemaParser syntaxCheckerParser = new SyntaxCheckerDescriptionSchemaParser();
    private final LdapSyntaxDescriptionSchemaParser syntaxParser = new LdapSyntaxDescriptionSchemaParser();
    private final MatchingRuleDescriptionSchemaParser matchingRuleParser = new MatchingRuleDescriptionSchemaParser();
    private final AttributeTypeDescriptionSchemaParser attributeTypeParser = new AttributeTypeDescriptionSchemaParser();
    private final ObjectClassDescriptionSchemaParser objectClassParser = new ObjectClassDescriptionSchemaParser();
    private final MatchingRuleUseDescriptionSchemaParser matchingRuleUseParser = new MatchingRuleUseDescriptionSchemaParser();
    private final DITStructureRuleDescriptionSchemaParser ditStructureRuleParser = new DITStructureRuleDescriptionSchemaParser();
    private final DITContentRuleDescriptionSchemaParser ditContentRuleParser = new DITContentRuleDescriptionSchemaParser();
    private final NameFormDescriptionSchemaParser nameFormParser = new NameFormDescriptionSchemaParser();
    private final SchemaManager schemaManager;

    public DescriptionParsers(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public SyntaxCheckerDescription[] parseSyntaxCheckers(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_SYNTAX_CHECKERS;
        }
        SyntaxCheckerDescription[] syntaxCheckerDescriptions = new SyntaxCheckerDescription[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            try {
                syntaxCheckerDescriptions[pos++] = this.syntaxCheckerParser.parseSyntaxCheckerDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_405, value), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
        }
        return syntaxCheckerDescriptions;
    }

    public NormalizerDescription[] parseNormalizers(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_NORMALIZERS;
        }
        NormalizerDescription[] normalizerDescriptions = new NormalizerDescription[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            try {
                normalizerDescriptions[pos++] = this.normalizerParser.parseNormalizerDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_406, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
        }
        return normalizerDescriptions;
    }

    public LdapComparatorDescription[] parseComparators(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_COMPARATORS;
        }
        LdapComparatorDescription[] comparatorDescriptions = new LdapComparatorDescription[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            try {
                comparatorDescriptions[pos++] = this.comparatorParser.parseComparatorDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_407, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
        }
        return comparatorDescriptions;
    }

    public AttributeType[] parseAttributeTypes(EntryAttribute attr) throws Exception {
        if (attr == null || attr.size() == 0) {
            return EMPTY_ATTRIBUTE_TYPES;
        }
        AttributeType[] attributeTypes = new AttributeType[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            AttributeType attributeType = null;
            try {
                attributeType = this.attributeTypeParser.parseAttributeTypeDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_408, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            if (attributeType.getSuperiorOid() != null && !this.schemaManager.getAttributeTypeRegistry().contains(attributeType.getSuperiorOid())) {
                throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_409, attributeType.getSuperiorOid()), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (attributeType.getSyntaxOid() != null && !this.schemaManager.getLdapSyntaxRegistry().contains(attributeType.getSyntaxOid())) {
                throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_410, attributeType.getSyntaxOid()), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (attributeType.getEqualityOid() != null && !this.schemaManager.getMatchingRuleRegistry().contains(attributeType.getEqualityOid())) {
                throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_411, attributeType.getEqualityOid()), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (attributeType.getOrderingOid() != null && !this.schemaManager.getMatchingRuleRegistry().contains(attributeType.getOrderingOid())) {
                throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_412, attributeType.getOrderingOid()), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (attributeType.getSubstringOid() != null && !this.schemaManager.getMatchingRuleRegistry().contains(attributeType.getSubstringOid())) {
                throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_413, attributeType.getSubstringOid()), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (attributeType.getEqualityOid() == null) {
                if (attributeType.getSuperiorOid() == null) {
                    throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_414, new Object[0]), ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
                AttributeType superType = this.schemaManager.lookupAttributeTypeRegistry(attributeType.getSuperiorOid());
                if (superType == null) {
                    throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_415, new Object[0]), ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
            }
            if (attributeType.getSyntaxOid() == null && attributeType.getSuperiorOid() == null) {
                throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_416, new Object[0]), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            ArrayList errors = new ArrayList();
            attributeType.setRegistries(this.schemaManager.getRegistries());
            attributeTypes[pos++] = attributeType;
        }
        return attributeTypes;
    }

    public ObjectClass[] parseObjectClasses(EntryAttribute attr) throws Exception {
        if (attr == null || attr.size() == 0) {
            return EMPTY_OBJECT_CLASSES;
        }
        ObjectClass[] objectClasses = new ObjectClass[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            ObjectClass objectClass = null;
            try {
                objectClass = this.objectClassParser.parseObjectClassDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_417, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            if (objectClass.getSuperiorOids() != null && objectClass.getSuperiorOids().size() > 0) {
                for (String superiorOid : objectClass.getSuperiorOids()) {
                    if (superiorOid.equals("2.5.6.0") || superiorOid.equalsIgnoreCase("top") || this.schemaManager.getObjectClassRegistry().contains(superiorOid)) continue;
                    throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_418, superiorOid), ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
            }
            if (objectClass.getMayAttributeTypeOids() != null && objectClass.getMayAttributeTypeOids().size() > 0) {
                for (String mayAttrOid : objectClass.getMayAttributeTypeOids()) {
                    if (this.schemaManager.getAttributeTypeRegistry().contains(mayAttrOid)) continue;
                    throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_419, mayAttrOid), ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
            }
            if (objectClass.getMustAttributeTypeOids() != null && objectClass.getMustAttributeTypeOids().size() > 0) {
                for (String mustAttrOid : objectClass.getMustAttributeTypeOids()) {
                    if (this.schemaManager.getAttributeTypeRegistry().contains(mustAttrOid)) continue;
                    throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_420, mustAttrOid), ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
            }
            ArrayList errors = new ArrayList();
            objectClass.setRegistries(this.schemaManager.getRegistries());
            objectClasses[pos++] = objectClass;
        }
        return objectClasses;
    }

    public MatchingRuleUse[] parseMatchingRuleUses(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_MATCHING_RULE_USES;
        }
        MatchingRuleUse[] matchingRuleUses = new MatchingRuleUse[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            MatchingRuleUse matchingRuleUse = null;
            try {
                matchingRuleUse = this.matchingRuleUseParser.parseMatchingRuleUseDescription(value.getString());
                matchingRuleUse.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_421, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            matchingRuleUses[pos++] = matchingRuleUse;
        }
        return matchingRuleUses;
    }

    public LdapSyntax[] parseLdapSyntaxes(EntryAttribute attr) throws Exception {
        if (attr == null || attr.size() == 0) {
            return EMPTY_SYNTAXES;
        }
        LdapSyntax[] syntaxes = new LdapSyntax[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            LdapSyntax ldapSyntax = null;
            try {
                ldapSyntax = this.syntaxParser.parseLdapSyntaxDescription(value.getString());
                ldapSyntax.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_422, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            if (!this.schemaManager.getSyntaxCheckerRegistry().contains(ldapSyntax.getOid())) {
                throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_423, new Object[0]), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            ldapSyntax.setHumanReadable(this.isHumanReadable(ldapSyntax));
            syntaxes[pos++] = ldapSyntax;
        }
        return syntaxes;
    }

    public MatchingRule[] parseMatchingRules(EntryAttribute attr) throws Exception {
        if (attr == null || attr.size() == 0) {
            return EMPTY_MATCHING_RULES;
        }
        MatchingRule[] matchingRules = new MatchingRule[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            MatchingRule matchingRule = null;
            try {
                matchingRule = this.matchingRuleParser.parseMatchingRuleDescription(value.getString());
                matchingRule.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_424, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            if (!this.schemaManager.getLdapSyntaxRegistry().contains(matchingRule.getSyntaxOid())) {
                throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_425, matchingRule.getSyntaxOid()), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            matchingRules[pos++] = matchingRule;
        }
        return matchingRules;
    }

    public DITStructureRule[] parseDitStructureRules(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_DIT_STRUCTURE_RULES;
        }
        DITStructureRule[] ditStructureRules = new DITStructureRule[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            DITStructureRule ditStructureRule = null;
            try {
                ditStructureRule = this.ditStructureRuleParser.parseDITStructureRuleDescription(value.getString());
                ditStructureRule.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_426, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            ditStructureRules[pos++] = ditStructureRule;
        }
        return ditStructureRules;
    }

    public DITContentRule[] parseDitContentRules(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_DIT_CONTENT_RULES;
        }
        DITContentRule[] ditContentRules = new DITContentRule[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            DITContentRule ditContentRule = null;
            try {
                ditContentRule = this.ditContentRuleParser.parseDITContentRuleDescription(value.getString());
                ditContentRule.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_427, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            ditContentRules[pos++] = ditContentRule;
        }
        return ditContentRules;
    }

    public NameForm[] parseNameForms(EntryAttribute attr) throws NamingException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_NAME_FORMS;
        }
        NameForm[] nameForms = new NameForm[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            NameForm nameForm = null;
            try {
                nameForm = this.nameFormParser.parseNameFormDescription(value.getString());
                nameForm.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(I18n.err(I18n.ERR_428, value.getString()), ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                iave.setRootCause(e);
                throw iave;
            }
            nameForms[pos++] = nameForm;
        }
        return nameForms;
    }

    private boolean isHumanReadable(LdapSyntax ldapSyntax) {
        List<String> values = ldapSyntax.getExtensions().get("X-IS-HUMAN-READABLE");
        if (values == null || values.size() == 0) {
            return false;
        }
        String value = values.get(0);
        return value.equals("TRUE");
    }
}

