/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(ComparatorSynchronizer.class);

    public ComparatorSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    @Override
    public boolean modify(ModifyOperationContext opContext, ServerEntry targetEntry, boolean cascade) throws Exception {
        DN name = opContext.getDn();
        ClonedServerEntry entry = opContext.getEntry();
        String schemaName = this.getSchemaName(name);
        String oid = this.getOid(entry);
        LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            comparator.setSchemaName(schemaName);
            this.schemaManager.unregisterComparator(oid);
            this.schemaManager.add(comparator);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(ServerEntry entry) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "Comparator");
        this.checkOidIsUniqueForComparator(entry);
        String schemaName = this.getSchemaName(dn);
        LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && comparator.isEnabled()) {
            if (this.schemaManager.add(comparator)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_350, entry.getDn().getName(), StringTools.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapOperationNotSupportedException(msg, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        LOG.debug("The Comparator {} cannot be added in the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete(ServerEntry entry, boolean cascade) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "Comparator");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The Comparator {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        LdapComparator<?> comparator = null;
        try {
            comparator = this.checkComparatorOidExists(entry);
        }
        catch (LdapSchemaViolationException lsve) {
            comparator = this.factory.getLdapComparator(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
            if (this.schemaManager.getRegistries().contains(comparator)) {
                this.schemaManager.getRegistries().dissociateFromSchema(comparator);
                return;
            }
            String msg = I18n.err(I18n.ERR_351, entry.getDn().getName());
            LOG.info(msg);
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        ArrayList errors = new ArrayList();
        if (schema.isEnabled() && comparator.isEnabled()) {
            if (this.schemaManager.delete(comparator)) {
                LOG.debug("Deleted {} from the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_352, entry.getDn().getName(), StringTools.listToString(errors));
            LOG.info(msg);
            throw new LdapOperationNotSupportedException(msg, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        LOG.debug("The Comparator {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    @Override
    public void rename(ServerEntry entry, RDN newRdn, boolean cascade) throws Exception {
        String oldOid = this.getOid(entry);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oldOid)) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_353, oldOid), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = newRdn.getNormValue();
        this.checkOidIsUniqueForComparator(oid);
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.isSchemaEnabled(schemaName)) {
            ServerEntry targetEntry = (ServerEntry)entry.clone();
            String newOid = newRdn.getNormValue();
            this.checkOidIsUnique(newOid);
            targetEntry.put("m-oid", newOid);
            DN newDn = new DN(targetEntry.getDn());
            newDn.remove(newDn.size() - 1);
            newDn.add(newRdn);
            targetEntry.setDn(newDn);
            LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
            this.schemaManager.unregisterComparator(oldOid);
            this.schemaManager.add(comparator);
        }
    }

    @Override
    public void moveAndRename(DN oriChildName, DN newParentName, RDN newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oldOid)) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_353, oldOid), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = newRdn.getNormValue();
        this.checkOidIsUniqueForComparator(oid);
        String newSchemaName = this.getSchemaName(newParentName);
        LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterComparator(oldOid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(comparator);
        }
    }

    @Override
    public void move(DN oriChildName, DN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oid)) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_354, oid), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String newSchemaName = this.getSchemaName(newParentName);
        LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterComparator(oid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(comparator);
        }
    }

    private void checkOidIsUniqueForComparator(String oid) throws NamingException {
        if (this.schemaManager.getComparatorRegistry().contains(oid)) {
            throw new LdapNamingException(I18n.err(I18n.ERR_355, oid), ResultCodeEnum.OTHER);
        }
    }

    private void checkOidIsUniqueForComparator(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.schemaManager.getComparatorRegistry().contains(oid)) {
            throw new LdapNamingException(I18n.err(I18n.ERR_355, oid), ResultCodeEnum.OTHER);
        }
    }

    protected LdapComparator<?> checkComparatorOidExists(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.schemaManager.getComparatorRegistry().contains(oid)) {
            return (LdapComparator)this.schemaManager.getComparatorRegistry().get(oid);
        }
        throw new LdapSchemaViolationException(I18n.err(I18n.ERR_336, oid), ResultCodeEnum.OTHER);
    }

    private void checkNewParent(DN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException(I18n.err(I18n.ERR_357, new Object[0]), ResultCodeEnum.NAMING_VIOLATION);
        }
        RDN rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException(I18n.err(I18n.ERR_358, new Object[0]), ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!rdn.getNormValue().equalsIgnoreCase("comparators")) {
            throw new LdapInvalidNameException(I18n.err(I18n.ERR_359, new Object[0]), ResultCodeEnum.NAMING_VIOLATION);
        }
    }
}

