/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.io.decoder.Decoder;
import org.apache.directory.server.kerberos.shared.io.decoder.DecoderFactory;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationData;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationDataEntry;
import org.apache.directory.server.kerberos.shared.messages.value.types.AuthorizationType;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class AuthorizationDataDecoder
implements Decoder,
DecoderFactory {
    public Decoder getDecoder() {
        return new AuthorizationDataDecoder();
    }

    public Encodable decode(byte[] encodedAuthData) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedAuthData);
        DERSequence sequence = (DERSequence)ais.readObject();
        return AuthorizationDataDecoder.decodeSequence(sequence);
    }

    protected static AuthorizationData decodeSequence(DERSequence sequence) {
        AuthorizationData authData = new AuthorizationData();
        Enumeration<DEREncodable> e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERSequence object = (DERSequence)e.nextElement();
            AuthorizationDataEntry entry = AuthorizationDataDecoder.decodeAuthorizationEntry(object);
            authData.add(entry);
        }
        return authData;
    }

    protected static AuthorizationDataEntry decodeAuthorizationEntry(DERSequence sequence) {
        AuthorizationType type = AuthorizationType.NULL;
        byte[] data = null;
        Enumeration<DEREncodable> e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    type = AuthorizationType.getTypeByOrdinal(tag0.intValue());
                    break;
                }
                case 1: {
                    DEROctetString tag1 = (DEROctetString)derObject;
                    data = tag1.getOctets();
                }
            }
        }
        return new AuthorizationDataEntry(type, data);
    }
}

