/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.io.decoder.KerberosTimeDecoder;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.LastRequest;
import org.apache.directory.server.kerberos.shared.messages.value.LastRequestEntry;
import org.apache.directory.server.kerberos.shared.messages.value.LastRequestType;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralizedTime;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class LastRequestDecoder {
    protected static LastRequest decodeSequence(DERSequence sequence) {
        LastRequestEntry[] entries = new LastRequestEntry[sequence.size()];
        int ii = 0;
        Enumeration<DEREncodable> e = sequence.getObjects();
        while (e.hasMoreElements()) {
            LastRequestEntry entry;
            DERSequence object = (DERSequence)e.nextElement();
            entries[ii] = entry = LastRequestDecoder.decode(object);
            ++ii;
        }
        return new LastRequest(entries);
    }

    protected static LastRequestEntry decode(DERSequence sequence) {
        LastRequestType type = LastRequestType.NONE;
        KerberosTime value = null;
        Enumeration<DEREncodable> e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    type = LastRequestType.getTypeByOrdinal(tag0.intValue());
                    break;
                }
                case 1: {
                    DERGeneralizedTime tag1 = (DERGeneralizedTime)derObject;
                    value = KerberosTimeDecoder.decode(tag1);
                }
            }
        }
        return new LastRequestEntry(type, value);
    }
}

