/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApproximateEvaluator<T, ID>
implements Evaluator<ApproximateNode<T>, ServerEntry, ID> {
    private final ApproximateNode<T> node;
    private final Store<ServerEntry, ID> db;
    private final SchemaManager schemaManager;
    private final AttributeType type;
    private final Normalizer normalizer;
    private final LdapComparator<? super Object> ldapComparator;
    private final Index<T, ServerEntry, ID> idx;

    public ApproximateEvaluator(ApproximateNode<T> node, Store<ServerEntry, ID> db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.node = node;
        this.schemaManager = schemaManager;
        if (db.hasIndexOn(node.getAttribute())) {
            this.idx = db.getIndex(node.getAttribute());
            this.type = null;
            this.normalizer = null;
            this.ldapComparator = null;
        } else {
            this.idx = null;
            this.type = schemaManager.lookupAttributeTypeRegistry(node.getAttribute());
            MatchingRule mr = this.type.getEquality();
            if (mr == null) {
                throw new IllegalStateException(I18n.err(I18n.ERR_709, node));
            }
            this.normalizer = mr.getNormalizer();
            this.ldapComparator = mr.getLdapComparator();
        }
    }

    @Override
    public ApproximateNode<T> getExpression() {
        return this.node;
    }

    @Override
    public boolean evaluateEntry(ServerEntry entry) throws Exception {
        ServerAttribute attr = (ServerAttribute)entry.get(this.type);
        if (attr != null && this.evaluate(attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = (ServerAttribute)entry.get(descendant);
                if (attr == null || !this.evaluate(attr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean evaluateId(ID id) throws Exception {
        if (this.idx != null) {
            return this.idx.reverse(id);
        }
        return this.evaluateEntry(this.db.lookup(id));
    }

    @Override
    public boolean evaluate(IndexEntry<?, ServerEntry, ID> indexEntry) throws Exception {
        if (this.idx != null) {
            return this.idx.forward(this.node.getValue().get(), indexEntry.getId());
        }
        ServerEntry entry = indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup(indexEntry.getId());
            indexEntry.setObject(entry);
        }
        return this.evaluateEntry(entry);
    }

    private boolean evaluate(ServerAttribute attribute) throws Exception {
        for (Value value : attribute) {
            value.normalize(this.normalizer);
            if (this.ldapComparator.compare(value.getNormalizedValue(), this.node.getValue().getNormalizedValue()) != 0) continue;
            return true;
        }
        return false;
    }
}

