/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.OrNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrEvaluator<ID>
implements Evaluator<OrNode, ServerEntry, ID> {
    private final List<Evaluator<? extends ExprNode, ServerEntry, ID>> evaluators;
    private final OrNode node;

    public OrEvaluator(OrNode node, List<Evaluator<? extends ExprNode, ServerEntry, ID>> evaluators) {
        this.node = node;
        this.evaluators = this.optimize(evaluators);
    }

    private List<Evaluator<? extends ExprNode, ServerEntry, ID>> optimize(List<Evaluator<? extends ExprNode, ServerEntry, ID>> unoptimized) {
        ArrayList<Evaluator<ExprNode, ServerEntry, ID>> optimized = new ArrayList<Evaluator<ExprNode, ServerEntry, ID>>(unoptimized.size());
        optimized.addAll(unoptimized);
        Collections.sort(optimized, new Comparator<Evaluator<? extends ExprNode, ServerEntry, ID>>(){

            @Override
            public int compare(Evaluator<? extends ExprNode, ServerEntry, ID> e1, Evaluator<? extends ExprNode, ServerEntry, ID> e2) {
                long scanCount2;
                long scanCount1 = (Long)e1.getExpression().get("count");
                if (scanCount1 == (scanCount2 = ((Long)e2.getExpression().get("count")).longValue())) {
                    return 0;
                }
                if (scanCount1 < scanCount2) {
                    return 1;
                }
                return -1;
            }
        });
        return optimized;
    }

    @Override
    public boolean evaluate(IndexEntry<?, ServerEntry, ID> indexEntry) throws Exception {
        for (Evaluator<ExprNode, ServerEntry, ID> evaluator : this.evaluators) {
            if (!evaluator.evaluate(indexEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluateId(ID id) throws Exception {
        for (Evaluator<ExprNode, ServerEntry, ID> evaluator : this.evaluators) {
            if (!evaluator.evaluateId(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluateEntry(ServerEntry entry) throws Exception {
        for (Evaluator<ExprNode, ServerEntry, ID> evaluator : this.evaluators) {
            if (!evaluator.evaluateEntry(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OrNode getExpression() {
        return this.node;
    }
}

