/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.engine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.dsmlv2.Dsmlv2Parser;
import org.apache.directory.shared.dsmlv2.reponse.AddResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.AuthResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.BatchResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.CompareResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.DelResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.ErrorResponse;
import org.apache.directory.shared.dsmlv2.reponse.ExtendedResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.ModDNResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.ModifyResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResultDoneDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResultEntryDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResultReferenceDsml;
import org.apache.directory.shared.dsmlv2.request.BatchRequest;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.add.AddResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.compare.CompareResponseCodec;
import org.apache.directory.shared.ldap.codec.del.DelResponseCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponseCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponseCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceCodec;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.xmlpull.v1.XmlPullParserException;

public class Dsmlv2Engine {
    private SocketChannel channel;
    private SocketAddress serverAddress;
    private int port;
    private String host;
    private String user;
    private String password;
    private Asn1Decoder ldapDecoder = new Asn1Decoder();
    private IAsn1Container ldapMessageContainer = new LdapMessageContainer();
    private Dsmlv2Parser parser;
    private boolean continueOnError;
    private boolean exit = false;
    private int bbLimit;
    private int bbposition;
    private BatchRequest batchRequest;
    private BatchResponseDsml batchResponse;

    public Dsmlv2Engine(String host, int port, String user, String password) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    public String processDSML(String dsmlInput) throws XmlPullParserException {
        this.parser = new Dsmlv2Parser();
        this.parser.setInput(dsmlInput);
        return this.processDSML();
    }

    public String processDSMLFile(String fileName) throws XmlPullParserException, FileNotFoundException {
        this.parser = new Dsmlv2Parser();
        this.parser.setInputFile(fileName);
        return this.processDSML();
    }

    public String processDSML(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        this.parser = new Dsmlv2Parser();
        this.parser.setInput(inputStream, inputEncoding);
        return this.processDSML();
    }

    private String processDSML() {
        this.batchResponse = new BatchResponseDsml();
        try {
            this.bind(1);
        }
        catch (Exception e) {
            ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.COULD_NOT_CONNECT, e.getLocalizedMessage());
            this.batchResponse.addResponse(errorResponse);
            return this.batchResponse.toDsml();
        }
        try {
            this.processBatchRequest();
        }
        catch (XmlPullParserException e) {
            ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err("ERR_03001", e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()));
            this.batchResponse.addResponse(errorResponse);
            return this.batchResponse.toDsml();
        }
        LdapMessageCodec request = null;
        try {
            request = this.parser.getNextRequest();
        }
        catch (XmlPullParserException e) {
            ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err("ERR_03001", e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()));
            this.batchResponse.addResponse(errorResponse);
            return this.batchResponse.toDsml();
        }
        while (request != null) {
            if (this.batchRequest.getProcessing().equals((Object)BatchRequest.Processing.PARALLEL) && this.batchRequest.getResponseOrder().equals((Object)BatchRequest.ResponseOrder.UNORDERED) && request.getMessageId() == 0) {
                ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err("ERR_03002", new Object[0]));
                this.batchResponse.addResponse(errorResponse);
                return this.batchResponse.toDsml();
            }
            try {
                this.processRequest(request);
            }
            catch (Exception e) {
                ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.GATEWAY_INTERNAL_ERROR, I18n.err("ERR_03003", e.getMessage()));
                this.batchResponse.addResponse(errorResponse);
                return this.batchResponse.toDsml();
            }
            if (this.exit) break;
            try {
                request = this.parser.getNextRequest();
            }
            catch (XmlPullParserException e) {
                ErrorResponse errorResponse = new ErrorResponse(0, ErrorResponse.ErrorResponseType.MALFORMED_REQUEST, I18n.err("ERR_03001", e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()));
                this.batchResponse.addResponse(errorResponse);
                return this.batchResponse.toDsml();
            }
        }
        return this.batchResponse.toDsml();
    }

    private void processRequest(LdapMessageCodec request) throws EncoderException, IOException, DecoderException, NamingException {
        ByteBuffer bb = request.encode();
        bb.flip();
        this.sendMessage(bb);
        bb.clear();
        bb.position(bb.capacity());
        LdapMessageCodec response = null;
        response = this.readResponse(bb);
        switch (response.getMessageType()) {
            case ADD_RESPONSE: {
                AddResponseCodec addResponse = (AddResponseCodec)response;
                this.copyMessageIdAndControls(response, addResponse);
                AddResponseDsml addResponseDsml = new AddResponseDsml(addResponse);
                this.batchResponse.addResponse(addResponseDsml);
                break;
            }
            case BIND_RESPONSE: {
                BindResponseCodec bindResponse = (BindResponseCodec)response;
                this.copyMessageIdAndControls(response, bindResponse);
                AuthResponseDsml authResponseDsml = new AuthResponseDsml(bindResponse);
                this.batchResponse.addResponse(authResponseDsml);
                break;
            }
            case COMPARE_RESPONSE: {
                CompareResponseCodec compareResponse = (CompareResponseCodec)response;
                this.copyMessageIdAndControls(response, compareResponse);
                CompareResponseDsml compareResponseDsml = new CompareResponseDsml(compareResponse);
                this.batchResponse.addResponse(compareResponseDsml);
                break;
            }
            case DEL_RESPONSE: {
                DelResponseCodec delResponse = (DelResponseCodec)response;
                this.copyMessageIdAndControls(response, delResponse);
                DelResponseDsml delResponseDsml = new DelResponseDsml(delResponse);
                this.batchResponse.addResponse(delResponseDsml);
                break;
            }
            case MODIFY_RESPONSE: {
                ModifyResponseCodec modifyResponse = (ModifyResponseCodec)response;
                this.copyMessageIdAndControls(response, modifyResponse);
                ModifyResponseDsml modifyResponseDsml = new ModifyResponseDsml(modifyResponse);
                this.batchResponse.addResponse(modifyResponseDsml);
                break;
            }
            case MODIFYDN_RESPONSE: {
                ModifyDNResponseCodec modifyDNResponse = (ModifyDNResponseCodec)response;
                this.copyMessageIdAndControls(response, modifyDNResponse);
                ModDNResponseDsml modDNResponseDsml = new ModDNResponseDsml(modifyDNResponse);
                this.batchResponse.addResponse(modDNResponseDsml);
                break;
            }
            case EXTENDED_RESPONSE: {
                ExtendedResponseCodec extendedResponse = (ExtendedResponseCodec)response;
                this.copyMessageIdAndControls(response, extendedResponse);
                ExtendedResponseDsml extendedResponseDsml = new ExtendedResponseDsml(extendedResponse);
                this.batchResponse.addResponse(extendedResponseDsml);
                break;
            }
            case SEARCH_RESULT_ENTRY: 
            case SEARCH_RESULT_REFERENCE: 
            case SEARCH_RESULT_DONE: {
                SearchResponseDsml searchResponseDsml = null;
                int requestID = response.getMessageId();
                while (MessageTypeEnum.SEARCH_RESULT_DONE != response.getMessageType()) {
                    if (MessageTypeEnum.SEARCH_RESULT_ENTRY == response.getMessageType()) {
                        SearchResultEntryCodec sre = (SearchResultEntryCodec)response;
                        this.copyMessageIdAndControls(response, sre);
                        SearchResultEntryDsml searchResultEntryDsml = new SearchResultEntryDsml(sre);
                        searchResponseDsml = new SearchResponseDsml(sre);
                        if (requestID != 0) {
                            searchResponseDsml.setMessageId(requestID);
                        }
                        searchResponseDsml.addResponse(searchResultEntryDsml);
                    } else if (MessageTypeEnum.SEARCH_RESULT_REFERENCE == response.getMessageType()) {
                        SearchResultReferenceCodec srr = (SearchResultReferenceCodec)response;
                        this.copyMessageIdAndControls(response, srr);
                        SearchResultReferenceDsml searchResultReferenceDsml = new SearchResultReferenceDsml(srr);
                        searchResponseDsml.addResponse(searchResultReferenceDsml);
                    }
                    response = this.readResponse(bb);
                }
                SearchResultDoneCodec srd = (SearchResultDoneCodec)response;
                this.copyMessageIdAndControls(response, srd);
                SearchResultDoneDsml searchResultDoneDsml = new SearchResultDoneDsml(srd);
                searchResponseDsml.addResponse(searchResultDoneDsml);
            }
        }
        LdapResponseCodec realResponse = (LdapResponseCodec)response;
        if (!this.continueOnError && realResponse.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS && realResponse.getLdapResult().getResultCode() != ResultCodeEnum.COMPARE_TRUE && realResponse.getLdapResult().getResultCode() != ResultCodeEnum.COMPARE_FALSE && realResponse.getLdapResult().getResultCode() != ResultCodeEnum.REFERRAL) {
            this.exit = true;
        }
    }

    private void copyMessageIdAndControls(LdapMessageCodec from, LdapMessageCodec to) {
        to.setMessageId(from.getMessageId());
        for (Control control : from.getControls()) {
            to.addControl(control);
        }
    }

    private void processBatchRequest() throws XmlPullParserException {
        this.parser.parseBatchRequest();
        this.batchRequest = this.parser.getBatchRequest();
        if (BatchRequest.OnError.RESUME.equals((Object)this.batchRequest.getOnError())) {
            this.continueOnError = true;
        } else if (BatchRequest.OnError.EXIT.equals((Object)this.batchRequest.getOnError())) {
            this.continueOnError = false;
        }
        if (this.batchRequest.getRequestID() != 0) {
            this.batchResponse.setRequestID(this.batchRequest.getRequestID());
        }
    }

    private void connect() throws UnknownHostException, IOException {
        this.serverAddress = new InetSocketAddress(this.host, this.port);
        this.channel = SocketChannel.open(this.serverAddress);
        this.channel.configureBlocking(true);
    }

    private void sendMessage(ByteBuffer bb) throws IOException {
        this.channel.write(bb);
        bb.clear();
    }

    private LdapMessageCodec readResponse(ByteBuffer bb) throws IOException, DecoderException, NamingException {
        ExtendedResponseCodec resp;
        LdapMessageCodec messageResp = null;
        if (bb.hasRemaining()) {
            bb.position(this.bbposition);
            bb.limit(this.bbLimit);
            this.ldapDecoder.decode(bb, this.ldapMessageContainer);
            this.bbposition = bb.position();
            this.bbLimit = bb.limit();
        }
        bb.flip();
        while (this.ldapMessageContainer.getState() != 1024) {
            int nbRead = this.channel.read(bb);
            if (nbRead == -1) {
                System.err.println("fsdfsdfsdfsd");
            }
            bb.flip();
            this.ldapDecoder.decode(bb, this.ldapMessageContainer);
            this.bbposition = bb.position();
            this.bbLimit = bb.limit();
            bb.flip();
        }
        messageResp = ((LdapMessageContainer)this.ldapMessageContainer).getLdapMessage();
        if (messageResp instanceof BindResponseCodec) {
            BindResponseCodec resp2 = ((LdapMessageContainer)this.ldapMessageContainer).getBindResponse();
            if (resp2.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
                System.err.println("Error : " + resp2.getLdapResult().getErrorMessage());
            }
        } else if (messageResp instanceof ExtendedResponseCodec && (resp = ((LdapMessageContainer)this.ldapMessageContainer).getExtendedResponse()).getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
            System.err.println("Error : " + resp.getLdapResult().getErrorMessage());
        }
        ((LdapMessageContainer)this.ldapMessageContainer).clean();
        return messageResp;
    }

    private void bind(int messageId) throws EncoderException, DecoderException, IOException, NamingException {
        BindRequestCodec bindRequest = new BindRequestCodec();
        SimpleAuthentication authentication = new SimpleAuthentication();
        authentication.setSimple(StringTools.getBytesUtf8(this.password));
        bindRequest.setAuthentication(authentication);
        bindRequest.setName(new DN(this.user));
        bindRequest.setVersion(3);
        bindRequest.setMessageId(messageId);
        ByteBuffer bb = bindRequest.encode();
        bb.flip();
        this.connect();
        this.sendMessage(bb);
        bb.clear();
        bb.position(bb.limit());
        this.readResponse(bb);
    }
}

