/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ErrorMessageAction() {
        super("Store error message");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapResponseCodec response = ldapMessageContainer.getLdapResponse();
        LdapResultCodec ldapResult = response.getLdapResult();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            ldapResult.setErrorMessage("");
        } else {
            ldapResult.setErrorMessage(StringTools.utf8ToString(tlv.getValue().getData()));
        }
        ldapMessageContainer.grammarEndAllowed(true);
        if (IS_DEBUG) {
            log.debug("The error message is : " + ldapResult.getErrorMessage());
        }
    }
}

