/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.exception;

import javax.naming.OperationNotSupportedException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class LdapOperationNotSupportedException
extends OperationNotSupportedException
implements LdapException {
    private static final long serialVersionUID = 1L;
    private final ResultCodeEnum resultCode;

    public LdapOperationNotSupportedException(String description, ResultCodeEnum resultCode) {
        super(description);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapOperationNotSupportedException(ResultCodeEnum resultCode) {
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        if (!resultCode.equals((Object)ResultCodeEnum.UNWILLING_TO_PERFORM) && !resultCode.equals((Object)ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION)) {
            throw new IllegalArgumentException(I18n.err("ERR_04142", new Object[0]));
        }
    }

    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }
}

