/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import java.io.IOException;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.PrepareString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericNormalizer
extends Normalizer {
    public static final long serialVersionUID = 1L;

    public NumericNormalizer() {
        super("2.5.13.8");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws NamingException {
        try {
            String normalized = PrepareString.normalize(value.getString(), PrepareString.StringType.NUMERIC_STRING);
            return new ClientStringValue(normalized);
        }
        catch (IOException ioe) {
            throw new NamingException(I18n.err("ERR_04224", value));
        }
    }

    @Override
    public String normalize(String value) throws NamingException {
        try {
            return PrepareString.normalize(value, PrepareString.StringType.NUMERIC_STRING);
        }
        catch (IOException ioe) {
            throw new NamingException(I18n.err("ERR_04224", value));
        }
    }
}

