/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.exceptions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorType
implements Comparable<ErrorType> {
    public static final ErrorType KRB5_KPASSWD_MALFORMED = new ErrorType(1, "Request failed due to being malformed.");
    public static final ErrorType KRB5_KPASSWD_HARDERROR = new ErrorType(2, "Request failed due to a hard error in processing the request.");
    public static final ErrorType KRB5_KPASSWD_AUTHERROR = new ErrorType(3, "Request failed due to an error in authentication processing.");
    public static final ErrorType KRB5_KPASSWD_SOFTERROR = new ErrorType(4, "Request failed due to a soft error in processing the request.");
    public static final ErrorType KRB5_KPASSWD_ACCESSDENIED = new ErrorType(5, "Requestor not authorized.");
    public static final ErrorType KRB5_KPASSWD_BAD_VERSION = new ErrorType(6, "Protocol version unsupported.");
    public static final ErrorType KRB5_KPASSWD_INITIAL_FLAG_NEEDED = new ErrorType(7, "Initial flag required.");
    public static final ErrorType KRB5_KPASSWD_UNKNOWN_ERROR = new ErrorType(8, "Request failed for an unknown reason.");
    private static final ErrorType[] values = new ErrorType[]{KRB5_KPASSWD_MALFORMED, KRB5_KPASSWD_HARDERROR, KRB5_KPASSWD_AUTHERROR, KRB5_KPASSWD_SOFTERROR, KRB5_KPASSWD_ACCESSDENIED, KRB5_KPASSWD_BAD_VERSION, KRB5_KPASSWD_INITIAL_FLAG_NEEDED, KRB5_KPASSWD_UNKNOWN_ERROR};
    public static final List<ErrorType> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private ErrorType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public String getMessage() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ErrorType that) {
        return this.ordinal - that.ordinal;
    }

    public static ErrorType getTypeByOrdinal(int ordinal) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (ErrorType.values[ii].ordinal != ordinal) continue;
            return values[ii];
        }
        return KRB5_KPASSWD_UNKNOWN_ERROR;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

