/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.io.File;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.changelog.ChangeLog;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.integ.FrameworkSuite;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(FrameworkRunner.class);
    private static final String DIRECTORY_SERVICE_FIELD_NAME = "service";
    private static final String LDAP_SERVER_FIELD_NAME = "ldapServer";
    private static final String KDC_SERVER_FIELD_NAME = "kdcServer";
    private static final String IS_RUN_IN_SUITE_FIELD_NAME = "isRunInSuite";
    private FrameworkSuite suite;
    private DirectoryService classDS;
    private LdapServer classLdapServer;
    private KdcServer classKdcServer;

    public FrameworkRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    public void run(RunNotifier notifier) {
        CreateLdapServer classLdapServerBuilder = (CreateLdapServer)this.getDescription().getAnnotation(CreateLdapServer.class);
        try {
            DirectoryServiceFactory dsf;
            this.classDS = DSAnnotationProcessor.getDirectoryService(this.getDescription());
            long revision = 0L;
            DirectoryService directoryService = null;
            if (this.classDS != null) {
                directoryService = this.classDS;
                if (this.suite != null) {
                    DSAnnotationProcessor.applyLdifs(this.suite.getDescription(), this.classDS);
                }
                DSAnnotationProcessor.applyLdifs(this.getDescription(), this.classDS);
            } else if (this.suite != null) {
                directoryService = this.suite.getDirectoryService();
                if (directoryService != null) {
                    revision = this.getCurrentRevision(directoryService);
                    DSAnnotationProcessor.applyLdifs(this.getDescription(), directoryService);
                } else {
                    dsf = DefaultDirectoryServiceFactory.DEFAULT;
                    directoryService = dsf.getDirectoryService();
                    directoryService.getChangeLog().setEnabled(true);
                    dsf.init("default" + UUID.randomUUID().toString());
                    this.suite.setDirectoryService(directoryService);
                    DSAnnotationProcessor.applyLdifs(this.suite.getDescription(), directoryService);
                    revision = this.getCurrentRevision(directoryService);
                    DSAnnotationProcessor.applyLdifs(this.getDescription(), directoryService);
                }
            } else {
                dsf = DefaultDirectoryServiceFactory.DEFAULT;
                directoryService = dsf.getDirectoryService();
                directoryService.getChangeLog().setEnabled(true);
                dsf.init("default" + UUID.randomUUID().toString());
                this.classDS = directoryService;
                DSAnnotationProcessor.applyLdifs(this.getDescription(), directoryService);
            }
            if (classLdapServerBuilder != null) {
                LdapServer suiteServer;
                int minPort = 0;
                if (this.suite != null && (suiteServer = this.suite.getLdapServer()) != null) {
                    for (Transport transport : suiteServer.getTransports()) {
                        if (minPort > transport.getPort()) continue;
                        minPort = transport.getPort();
                    }
                }
                this.classLdapServer = ServerAnnotationProcessor.getLdapServer(this.getDescription(), directoryService, minPort + 1);
            } else if (this.suite != null && this.suite.getLdapServer() != null) {
                this.classLdapServer = this.suite.getLdapServer();
                if (directoryService == null) {
                    directoryService = this.classLdapServer.getDirectoryService();
                }
            }
            if (this.classKdcServer == null) {
                this.classKdcServer = ServerAnnotationProcessor.getKdcServer(this.getDescription(), directoryService, 0);
            } else if (this.suite != null) {
                // empty if block
            }
            if (this.suite == null) {
                PartitionFactory partitionFactory = DefaultDirectoryServiceFactory.DEFAULT.getPartitionFactory();
                System.out.println("Using partition factory " + partitionFactory.getClass().getSimpleName());
            }
            super.run(notifier);
            if (this.classLdapServer != null && (this.suite == null || this.suite.getLdapServer() != this.classLdapServer)) {
                this.classLdapServer.stop();
            }
            if (this.classKdcServer != null) {
                this.classKdcServer.stop();
            }
            if (this.classDS != null) {
                LOG.debug("Shuting down DS for {}", (Object)this.classDS.getInstanceId());
                this.classDS.shutdown();
                FileUtils.deleteDirectory((File)this.classDS.getWorkingDirectory());
            } else {
                this.revert(directoryService, revision);
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_181, this.getTestClass().getName()));
            LOG.error(e.getLocalizedMessage());
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (method.getAnnotation(Ignore.class) != null) {
            Description description = this.describeChild(method);
            notifier.fireTestIgnored(description);
            return;
        }
        Description suiteDescription = null;
        if (this.suite != null) {
            suiteDescription = this.suite.getDescription();
        }
        Description classDescription = this.getDescription();
        Description methodDescription = this.describeChild(method);
        try {
            DirectoryService directoryService = null;
            long revision = 0L;
            DirectoryService methodDS = DSAnnotationProcessor.getDirectoryService(methodDescription);
            if (methodDS != null) {
                DSAnnotationProcessor.applyLdifs(suiteDescription, methodDS);
                DSAnnotationProcessor.applyLdifs(classDescription, methodDS);
                DSAnnotationProcessor.applyLdifs(methodDescription, methodDS);
                directoryService = methodDS;
            } else if (this.classDS != null) {
                directoryService = this.classDS;
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs(methodDescription, directoryService);
            } else if (this.classLdapServer != null) {
                directoryService = this.classLdapServer.getDirectoryService();
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs(methodDescription, directoryService);
            } else if (this.classKdcServer != null) {
                directoryService = this.classKdcServer.getDirectoryService();
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs(methodDescription, directoryService);
            } else if (this.suite != null) {
                directoryService = this.suite.getDirectoryService();
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs(methodDescription, directoryService);
            }
            Field dirServiceField = this.getTestClass().getJavaClass().getField(DIRECTORY_SERVICE_FIELD_NAME);
            dirServiceField.set(this.getTestClass().getJavaClass(), directoryService);
            Field runInSuiteField = this.getTestClass().getJavaClass().getField(IS_RUN_IN_SUITE_FIELD_NAME);
            runInSuiteField.set(this.getTestClass().getJavaClass(), this.suite != null);
            Field ldapServerField = this.getTestClass().getJavaClass().getField(LDAP_SERVER_FIELD_NAME);
            dirServiceField.set(this.getTestClass().getJavaClass(), directoryService);
            DirectoryService oldLdapServerDirService = null;
            DirectoryService oldKdcServerDirService = null;
            if (this.classLdapServer != null) {
                oldLdapServerDirService = this.classLdapServer.getDirectoryService();
                this.classLdapServer.setDirectoryService(directoryService);
                ldapServerField.set(this.getTestClass().getJavaClass(), this.classLdapServer);
            } else if (this.classKdcServer != null) {
                oldKdcServerDirService = this.classKdcServer.getDirectoryService();
                this.classKdcServer.setDirectoryService(directoryService);
                Field kdcServerField = this.getTestClass().getJavaClass().getField(KDC_SERVER_FIELD_NAME);
                kdcServerField.set(this.getTestClass().getJavaClass(), this.classKdcServer);
            }
            super.runChild(method, notifier);
            if (oldLdapServerDirService != null) {
                this.classLdapServer.setDirectoryService(oldLdapServerDirService);
            }
            if (oldKdcServerDirService != null) {
                this.classKdcServer.setDirectoryService(oldKdcServerDirService);
            }
            if (methodDS != null) {
                LOG.debug("Shuting down DS for {}", (Object)methodDS.getInstanceId());
                methodDS.shutdown();
                FileUtils.deleteDirectory((File)methodDS.getWorkingDirectory());
            } else {
                this.revert(directoryService, revision);
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_182, method.getName()));
            LOG.error("", e);
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
        }
    }

    public void setSuite(FrameworkSuite suite) {
        this.suite = suite;
    }

    public FrameworkSuite getSuite() {
        return this.suite;
    }

    private long getCurrentRevision(DirectoryService dirService) throws Exception {
        if (dirService != null && dirService.getChangeLog().isEnabled()) {
            long revision = dirService.getChangeLog().getCurrentRevision();
            LOG.debug("Create revision {}", revision);
            return revision;
        }
        return 0L;
    }

    private void revert(DirectoryService dirService, long revision) throws Exception {
        if (dirService == null) {
            return;
        }
        ChangeLog cl = dirService.getChangeLog();
        if (cl.isEnabled() && revision < cl.getCurrentRevision()) {
            LOG.debug("Revert revision {}", revision);
            dirService.revert(revision);
        }
    }
}

