/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEntrySerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ServerEntrySerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private transient SchemaManager schemaManager;

    public ServerEntrySerializer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public byte[] serialize(Object object) throws IOException {
        DefaultServerEntry entry = (DefaultServerEntry)object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        entry.serialize(out);
        out.flush();
        if (IS_DEBUG) {
            LOG.debug(">------------------------------------------------");
            LOG.debug("Serialize " + entry);
        }
        return baos.toByteArray();
    }

    public Object deserialize(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager);
        try {
            serverEntry.deserialize(in);
            return serverEntry;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err(I18n.ERR_134, cnfe.getLocalizedMessage()));
            return null;
        }
    }
}

