/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.protocol;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.messages.MessageType;
import org.apache.directory.server.dhcp.protocol.DhcpProtocolCodecFactory;
import org.apache.directory.server.dhcp.service.DhcpService;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpProtocolHandler
implements IoHandler {
    private static final Logger logger = LoggerFactory.getLogger(DhcpProtocolHandler.class);
    public static final int CLIENT_PORT = 68;
    public static final int SERVER_PORT = 67;
    private final DhcpService dhcpService;

    public DhcpProtocolHandler(DhcpService service) {
        this.dhcpService = service;
    }

    public void sessionCreated(IoSession session) throws Exception {
        logger.debug("{} CREATED", session.getLocalAddress());
        session.getFilterChain().addFirst("codec", new ProtocolCodecFilter(new DhcpProtocolCodecFactory()));
    }

    public void sessionOpened(IoSession session) {
        logger.debug("{} -> {} OPENED", session.getRemoteAddress(), (Object)session.getLocalAddress());
    }

    public void sessionClosed(IoSession session) {
        logger.debug("{} -> {} CLOSED", session.getRemoteAddress(), (Object)session.getLocalAddress());
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        logger.error("EXCEPTION CAUGHT ", cause);
        cause.printStackTrace(System.out);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("{} -> {} RCVD: {} " + message, session.getRemoteAddress(), (Object)session.getLocalAddress());
        }
        DhcpMessage request = (DhcpMessage)message;
        DhcpMessage reply = this.dhcpService.getReplyFor((InetSocketAddress)session.getServiceAddress(), (InetSocketAddress)session.getRemoteAddress(), request);
        if (null != reply) {
            InetSocketAddress isa = this.determineMessageDestination(request, reply);
            session.write(reply, isa);
        }
    }

    private InetSocketAddress determineMessageDestination(DhcpMessage request, DhcpMessage reply) {
        MessageType mt = reply.getMessageType();
        if (!this.isNullAddress(request.getRelayAgentAddress())) {
            return new InetSocketAddress(request.getRelayAgentAddress(), 67);
        }
        if (null != mt && mt == MessageType.DHCPNAK) {
            return new InetSocketAddress("255.255.255.255", 68);
        }
        if (!this.isNullAddress(request.getCurrentClientAddress())) {
            return new InetSocketAddress(request.getCurrentClientAddress(), 68);
        }
        return new InetSocketAddress("255.255.255.255", 68);
    }

    private boolean isNullAddress(InetAddress addr) {
        byte[] a = addr.getAddress();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void messageSent(IoSession session, Object message) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} -> {} SENT: " + message, session.getRemoteAddress(), (Object)session.getLocalAddress());
        }
    }
}

