/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXdbmPartition<ID>
extends BTreePartition<ID> {
    protected boolean optimizerEnabled = true;
    protected Store<ServerEntry, ID> store;

    protected AbstractXdbmPartition(Store<ServerEntry, ID> store) {
        this.store = store;
    }

    @Override
    protected void doDestroy() throws Exception {
        this.store.destroy();
    }

    @Override
    public final boolean isInitialized() {
        return this.store.isInitialized();
    }

    @Override
    public final void sync() throws Exception {
        this.store.sync();
    }

    public boolean isOptimizerEnabled() {
        return this.optimizerEnabled;
    }

    public void setOptimizerEnabled(boolean optimizerEnabled) {
        this.optimizerEnabled = optimizerEnabled;
    }

    public void setSyncOnWrite(boolean syncOnWrite) {
        this.store.setSyncOnWrite(syncOnWrite);
    }

    public boolean isSyncOnWrite() {
        return this.store.isSyncOnWrite();
    }

    @Override
    public final void addIndexOn(Index<? extends Object, ServerEntry, ID> index) throws Exception {
        this.store.addIndex(index);
    }

    public final Index<String, ServerEntry, ID> getExistenceIndex() {
        return this.store.getPresenceIndex();
    }

    @Override
    public final void setPresenceIndexOn(Index<String, ServerEntry, ID> index) throws Exception {
        this.store.setPresenceIndex(index);
    }

    @Override
    public final Index<ID, ServerEntry, ID> getOneLevelIndex() {
        return this.store.getOneLevelIndex();
    }

    @Override
    public final void setOneLevelIndexOn(Index<ID, ServerEntry, ID> index) throws Exception {
        this.store.setOneLevelIndex(index);
    }

    @Override
    public final Index<String, ServerEntry, ID> getAliasIndex() {
        return this.store.getAliasIndex();
    }

    @Override
    public final void setAliasIndexOn(Index<String, ServerEntry, ID> index) throws Exception {
        this.store.setAliasIndex(index);
    }

    @Override
    public final Index<ID, ServerEntry, ID> getOneAliasIndex() {
        return this.store.getOneAliasIndex();
    }

    @Override
    public final void setOneAliasIndexOn(Index<ID, ServerEntry, ID> index) throws Exception {
        this.store.setOneAliasIndex(index);
    }

    @Override
    public final Index<ID, ServerEntry, ID> getSubAliasIndex() {
        return this.store.getSubAliasIndex();
    }

    @Override
    public final void setSubAliasIndexOn(Index<ID, ServerEntry, ID> index) throws Exception {
        this.store.setSubAliasIndex(index);
    }

    @Override
    public final Index<String, ServerEntry, ID> getUpdnIndex() {
        return this.store.getUpdnIndex();
    }

    @Override
    public final void setUpdnIndexOn(Index<String, ServerEntry, ID> index) throws Exception {
        this.store.setUpdnIndex(index);
    }

    @Override
    public final Index<String, ServerEntry, ID> getNdnIndex() {
        return this.store.getNdnIndex();
    }

    @Override
    public final void setNdnIndexOn(Index<String, ServerEntry, ID> index) throws Exception {
        this.store.setNdnIndex(index);
    }

    @Override
    public final Iterator<String> getUserIndices() {
        return this.store.userIndices();
    }

    @Override
    public final Iterator<String> getSystemIndices() {
        return this.store.systemIndices();
    }

    @Override
    public final boolean hasUserIndexOn(String id) throws Exception {
        return this.store.hasUserIndexOn(id);
    }

    @Override
    public final boolean hasSystemIndexOn(String id) throws Exception {
        return this.store.hasSystemIndexOn(id);
    }

    @Override
    public final Index<? extends Object, ServerEntry, ID> getUserIndex(String id) throws IndexNotFoundException {
        return this.store.getUserIndex(id);
    }

    @Override
    public final Index<? extends Object, ServerEntry, ID> getSystemIndex(String id) throws IndexNotFoundException {
        return this.store.getSystemIndex(id);
    }

    @Override
    public final ID getEntryId(String dn) throws Exception {
        return this.store.getEntryId(dn);
    }

    @Override
    public final String getEntryDn(ID id) throws Exception {
        return this.store.getEntryDn(id);
    }

    @Override
    public final ID getParentId(String dn) throws Exception {
        return (ID)this.store.getParentId(dn);
    }

    @Override
    public final ID getParentId(ID childId) throws Exception {
        return this.store.getParentId(childId);
    }

    @Override
    public final String getEntryUpdn(ID id) throws Exception {
        return this.store.getEntryUpdn(id);
    }

    @Override
    public final String getEntryUpdn(String dn) throws Exception {
        return this.store.getEntryUpdn(dn);
    }

    @Override
    public final int count() throws Exception {
        return this.store.count();
    }

    @Override
    public final void add(AddOperationContext addContext) throws Exception {
        this.store.add((ServerEntry)addContext.getEntry().getClonedEntry());
    }

    @Override
    public final ClonedServerEntry lookup(ID id) throws Exception {
        return new ClonedServerEntry(this.store.lookup(id));
    }

    @Override
    public final void delete(ID id) throws Exception {
        this.store.delete(id);
    }

    @Override
    public final IndexCursor<ID, ServerEntry, ID> list(ID id) throws Exception {
        return this.store.list(id);
    }

    @Override
    public final int getChildCount(ID id) throws Exception {
        return this.store.getChildCount(id);
    }

    @Override
    public final void setProperty(String propertyName, String propertyValue) throws Exception {
        this.store.setProperty(propertyName, propertyValue);
    }

    @Override
    public final String getProperty(String propertyName) throws Exception {
        return this.store.getProperty(propertyName);
    }

    @Override
    public final void modify(ModifyOperationContext modifyContext) throws Exception {
        this.store.modify(modifyContext.getDn(), modifyContext.getModItems());
    }

    @Override
    public final void rename(RenameOperationContext renameContext) throws Exception {
        this.store.rename(renameContext.getDn(), renameContext.getNewRdn(), renameContext.getDelOldDn());
    }

    @Override
    public final void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws Exception {
        this.checkIsValidMove(moveAndRenameContext.getDn(), moveAndRenameContext.getParent());
        this.store.move(moveAndRenameContext.getDn(), moveAndRenameContext.getParent(), moveAndRenameContext.getNewRdn(), moveAndRenameContext.getDelOldDn());
    }

    @Override
    public final void move(MoveOperationContext moveContext) throws Exception {
        this.checkIsValidMove(moveContext.getDn(), moveContext.getParent());
        this.store.move(moveContext.getDn(), moveContext.getParent());
    }

    private void checkIsValidMove(DN oldChildDn, DN newParentDn) throws Exception {
        boolean invalid = false;
        DN newParentDNClone = (DN)newParentDn.clone();
        newParentDNClone.remove(newParentDNClone.size() - 1);
        if (newParentDn.size() >= oldChildDn.size()) {
            for (int i = 0; i < oldChildDn.size(); ++i) {
                RDN ldapRdn;
                RDN nameRdn = oldChildDn.getRdn(i);
                if (nameRdn.compareTo(ldapRdn = newParentDn.getRdn(i)) != 0) {
                    invalid = false;
                    break;
                }
                invalid = true;
            }
        }
        if (invalid) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "cannot place an entry below itself");
        }
    }

    public final void bind(DN bindDn, byte[] credentials, List<String> mechanisms, String saslAuthId) throws Exception {
        if (bindDn == null || credentials == null || mechanisms == null || saslAuthId == null) {
            // empty if block
        }
        throw new LdapAuthenticationNotSupportedException(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED, I18n.err(I18n.ERR_702, new Object[0]));
    }

    @Override
    public final void bind(BindOperationContext bindContext) throws Exception {
        throw new LdapAuthenticationNotSupportedException(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED, I18n.err(I18n.ERR_702, new Object[0]));
    }

    @Override
    public final void unbind(UnbindOperationContext unbindContext) throws Exception {
    }

    @Override
    public final Index<String, ServerEntry, ID> getPresenceIndex() {
        return this.store.getPresenceIndex();
    }

    @Override
    public final Index<ID, ServerEntry, ID> getSubLevelIndex() {
        return this.store.getSubLevelIndex();
    }

    public String toString() {
        return "Partition<" + this.id + ">";
    }
}

