/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.AbstractValue;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultServerAttribute
extends DefaultClientAttribute
implements EntryAttribute {
    public static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServerAttribute.class);

    public DefaultServerAttribute(AttributeType attributeType, EntryAttribute attribute) {
        this.attributeType = attributeType;
        this.id = attribute.getId();
        this.upId = attribute.getUpId();
        if (attributeType == null) {
            this.isHR = attribute.isHR();
            for (Value value : attribute) {
                this.add(value.clone());
            }
        } else {
            this.isHR = attributeType.getSyntax().isHumanReadable();
            for (Value clientValue : attribute) {
                AbstractValue serverValue = null;
                if (clientValue instanceof StringValue) {
                    serverValue = this.isHR.booleanValue() ? new StringValue(attributeType, clientValue.getString()) : new BinaryValue(attributeType, clientValue.getBytes());
                } else if (clientValue instanceof BinaryValue) {
                    serverValue = this.isHR != false ? new StringValue(attributeType, clientValue.getString()) : new BinaryValue(attributeType, clientValue.getBytes());
                }
                this.add(serverValue);
            }
        }
    }

    public DefaultServerAttribute(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err("ERR_04442", new Object[0]));
        }
        this.setAttributeType(attributeType);
    }

    public DefaultServerAttribute(String upId, AttributeType attributeType) {
        if (attributeType == null) {
            String message = I18n.err("ERR_04442", new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.setAttributeType(attributeType);
        this.setUpId(upId, attributeType);
    }

    public DefaultServerAttribute(AttributeType attributeType, Value<?> ... vals) {
        this(null, attributeType, vals);
    }

    public DefaultServerAttribute(String upId, AttributeType attributeType, Value<?> ... vals) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err("ERR_04442", new Object[0]));
        }
        this.setAttributeType(attributeType);
        this.setUpId(upId, attributeType);
        this.add(vals);
    }

    public DefaultServerAttribute(AttributeType attributeType, String ... vals) {
        this(null, attributeType, vals);
    }

    public DefaultServerAttribute(String upId, AttributeType attributeType, String ... vals) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err("ERR_04442", new Object[0]));
        }
        this.setAttributeType(attributeType);
        this.add(vals);
        this.setUpId(upId, attributeType);
    }

    public DefaultServerAttribute(AttributeType attributeType, byte[] ... vals) {
        this(null, attributeType, vals);
    }

    public DefaultServerAttribute(String upId, AttributeType attributeType, byte[] ... vals) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err("ERR_04442", new Object[0]));
        }
        this.setAttributeType(attributeType);
        this.add(vals);
        this.setUpId(upId, attributeType);
    }

    @Override
    public int add(byte[] ... vals) {
        if (!this.isHR.booleanValue()) {
            int nbAdded = 0;
            for (byte[] val : vals) {
                BinaryValue value = new BinaryValue(this.attributeType, val);
                try {
                    value.normalize();
                }
                catch (LdapException ne) {
                    LOG.error(I18n.err("ERR_04449", StringTools.dumpBytes(val)));
                    return 0;
                }
                if (this.add(value) != 0) {
                    ++nbAdded;
                    continue;
                }
                LOG.error(I18n.err("ERR_04450", StringTools.dumpBytes(val)));
            }
            return nbAdded;
        }
        return 0;
    }

    @Override
    public int add(String ... vals) {
        if (this.isHR.booleanValue()) {
            int nbAdded = 0;
            for (String val : vals) {
                StringValue newValue = new StringValue(this.attributeType, val);
                if (this.add(newValue) != 0) {
                    ++nbAdded;
                    continue;
                }
                LOG.error(I18n.err("ERR_04450", val));
            }
            return nbAdded;
        }
        return 0;
    }

    @Override
    public int add(Value<?> ... vals) {
        int nbAdded = 0;
        for (Value<?> val : vals) {
            String message;
            AbstractValue nullSV;
            if (this.attributeType.getSyntax().isHumanReadable()) {
                if (val == null || val.isNull()) {
                    nullSV = new StringValue(this.attributeType, null);
                    if (!this.values.add(nullSV)) continue;
                    ++nbAdded;
                    continue;
                }
                if (val instanceof StringValue) {
                    StringValue stringValue = (StringValue)val;
                    if (stringValue.getAttributeType() == null) {
                        stringValue.apply(this.attributeType);
                    }
                    if (!this.values.add(val)) continue;
                    ++nbAdded;
                    continue;
                }
                message = I18n.err("ERR_04451", new Object[0]);
                LOG.error(message);
                continue;
            }
            if (val == null) {
                nullSV = new BinaryValue(this.attributeType, null);
                if (!this.values.add(nullSV)) continue;
                ++nbAdded;
                continue;
            }
            if (val instanceof BinaryValue) {
                BinaryValue binaryValue = (BinaryValue)val;
                if (binaryValue.getAttributeType() == null) {
                    binaryValue = new BinaryValue(this.attributeType, val.getBytes());
                }
                if (!this.values.add(binaryValue)) continue;
                ++nbAdded;
                continue;
            }
            message = I18n.err("ERR_04452", new Object[0]);
            LOG.error(message);
        }
        return nbAdded;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean contains(byte[] ... vals) {
        if (!this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                BinaryValue value = new BinaryValue(this.attributeType, val);
                try {
                    value.normalize();
                }
                catch (LdapException ne) {
                    return false;
                }
                if (this.values.contains(value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String ... vals) {
        if (this.isHR.booleanValue()) {
            for (String val : vals) {
                StringValue value = new StringValue(this.attributeType, val);
                if (this.values.contains(value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Value<?> ... vals) {
        if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof StringValue) {
                    StringValue stringValue = (StringValue)val;
                    if (stringValue.getAttributeType() == null) {
                        stringValue.apply(this.attributeType);
                    }
                    if (this.values.contains(val)) continue;
                    return false;
                }
                return false;
            }
        } else {
            for (Value<?> val : vals) {
                if (val instanceof BinaryValue) {
                    if (this.values.contains(val)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValid() throws LdapException {
        if (this.attributeType.isSingleValued() && this.values.size() > 1) {
            return false;
        }
        if (this.values.size() == 0) {
            return this.attributeType.getSyntax().getSyntaxChecker().isValidSyntax(null);
        }
        for (Value value : this.values) {
            if (value.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(byte[] ... vals) {
        if (this.isHR.booleanValue()) {
            return false;
        }
        boolean removed = true;
        for (byte[] val : vals) {
            BinaryValue value = new BinaryValue(this.attributeType, val);
            removed &= this.values.remove(value);
        }
        return removed;
    }

    @Override
    public boolean remove(String ... vals) {
        if (!this.isHR.booleanValue()) {
            return false;
        }
        boolean removed = true;
        for (String val : vals) {
            StringValue value = new StringValue(this.attributeType, val);
            removed &= this.values.remove(value);
        }
        return removed;
    }

    @Override
    public boolean remove(Value<?> ... vals) {
        boolean removed = true;
        if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof StringValue) {
                    StringValue stringValue = (StringValue)val;
                    if (stringValue.getAttributeType() == null) {
                        stringValue.apply(this.attributeType);
                    }
                    removed &= this.values.remove(stringValue);
                    continue;
                }
                removed = false;
            }
        } else {
            for (Value<?> val : vals) {
                if (val instanceof BinaryValue) {
                    BinaryValue binaryValue = (BinaryValue)val;
                    if (binaryValue.getAttributeType() == null) {
                        binaryValue = new BinaryValue(this.attributeType, (byte[])val.get());
                    }
                    removed &= this.values.remove(binaryValue);
                    continue;
                }
                removed = false;
            }
        }
        return removed;
    }

    @Override
    public void setHR(boolean isHR) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setId(String id) {
        if (StringTools.isEmpty(StringTools.trim(id))) throw new IllegalArgumentException(I18n.err("ERR_04456", new Object[0]));
        if (this.attributeType.getName() == null) {
            if (!OID.isOID(id) || !this.attributeType.getOid().equals(id)) return;
            super.setId(id);
            return;
        } else {
            String normId = StringTools.lowerCaseAscii(StringTools.trim(id));
            for (String atName : this.attributeType.getNames()) {
                if (!atName.equalsIgnoreCase(normId)) continue;
                super.setId(normId);
                return;
            }
            if (!OID.isOID(normId) || !this.attributeType.getOid().equals(normId)) throw new IllegalArgumentException(I18n.err("ERR_04455", id, this.attributeType.getName()));
            super.setUpId(normId);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException(I18n.err("ERR_04454", new Object[0]));
    }

    public void serialize(ObjectOutput out) throws IOException {
        out.writeUTF(this.upId);
        if (this.isHR != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.isHR);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.size());
        if (this.size() > 0) {
            for (Value value : this.values) {
                if (value instanceof StringValue) {
                    ((StringValue)value).serialize(out);
                    continue;
                }
                ((BinaryValue)value).serialize(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException(I18n.err("ERR_04454", new Object[0]));
    }

    public void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        int nbValues;
        this.upId = in.readUTF();
        this.setUpId(this.upId);
        if (in.readBoolean()) {
            this.isHR = in.readBoolean();
        }
        if ((nbValues = in.readInt()) > 0) {
            for (int i = 0; i < nbValues; ++i) {
                AbstractValue value = null;
                if (this.isHR.booleanValue()) {
                    value = new StringValue(this.attributeType);
                    ((StringValue)value).deserialize(in);
                } else {
                    value = new BinaryValue(this.attributeType);
                    ((BinaryValue)value).deserialize(in);
                }
                try {
                    value.normalize();
                }
                catch (LdapException ne) {
                    // empty catch block
                }
                this.values.add(value);
            }
        }
    }

    @Override
    public EntryAttribute clone() {
        EntryAttribute clone = super.clone();
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntryAttribute)) {
            return false;
        }
        EntryAttribute other = (EntryAttribute)obj;
        if (!this.attributeType.equals(other.getAttributeType())) {
            return false;
        }
        if (this.values.size() != other.size()) {
            return false;
        }
        for (Value val : this.values) {
            if (other.contains(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        if (this.attributeType != null) {
            h = h * 17 + this.attributeType.hashCode();
        }
        return h;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.values != null && this.values.size() != 0) {
            for (Value value : this.values) {
                sb.append("    ").append(this.upId).append(": ");
                if (value.isNull()) {
                    sb.append("''");
                } else {
                    sb.append(value);
                }
                sb.append('\n');
            }
        } else {
            sb.append("    ").append(this.upId).append(": (null)\n");
        }
        return sb.toString();
    }
}

