/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.loader.ldif;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.schema.registries.AbstractSchemaLoader;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifSchemaLoader
extends AbstractSchemaLoader {
    private static final String LDIF_EXT = "ldif";
    private static final String OU_SCHEMA_LDIF = "ou=schema.ldif";
    private static final Logger LOG = LoggerFactory.getLogger(LdifSchemaLoader.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final String ADMIN_SYSTEM_DN = "uid=admin,ou=system";
    private final File baseDirectory;
    private final FilenameFilter ldifFilter = new FilenameFilter(){

        public boolean accept(File file, String name) {
            return name.endsWith(LdifSchemaLoader.LDIF_EXT);
        }
    };

    public LdifSchemaLoader(File baseDirectory) throws Exception {
        this.baseDirectory = baseDirectory;
        if (!baseDirectory.exists()) {
            String msg = "Provided baseDirectory '" + baseDirectory.getAbsolutePath() + "' does not exist.";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        File schemaLdif = new File(baseDirectory, OU_SCHEMA_LDIF);
        if (!schemaLdif.exists()) {
            String msg = I18n.err("ERR_10004", schemaLdif.getAbsolutePath());
            LOG.error(msg);
            throw new FileNotFoundException(msg);
        }
        if (IS_DEBUG) {
            LOG.debug("Using '{}' as the base schema load directory.", baseDirectory);
        }
        this.initializeSchemas();
    }

    private void initializeSchemas() throws Exception {
        String[] ldifFiles;
        if (IS_DEBUG) {
            LOG.debug("Initializing schema");
        }
        File schemaDirectory = new File(this.baseDirectory, "ou=schema");
        for (String ldifFile : ldifFiles = schemaDirectory.list(this.ldifFilter)) {
            File file = new File(schemaDirectory, ldifFile);
            try {
                LdifReader reader = new LdifReader(file);
                LdifEntry entry = reader.next();
                reader.close();
                Schema schema = this.getSchema(entry.getEntry());
                if (schema == null) continue;
                this.schemaMap.put(schema.getSchemaName(), schema);
                if (!IS_DEBUG) continue;
                LOG.debug("Schema Initialized ... \n{}", schema);
            }
            catch (Exception e) {
                LOG.error(I18n.err("ERR_10003", ldifFile), e);
                throw e;
            }
        }
    }

    private void enableSchema(Schema schema) throws Exception {
        File schemaLdifFile = new File(new File(this.baseDirectory, "ou=schema"), "cn=" + schema.getSchemaName() + "." + LDIF_EXT);
        LdifReader reader = new LdifReader(schemaLdifFile);
        LdifEntry ldifEntry = reader.next();
        Entry entry = ldifEntry.getEntry();
        entry.removeAttributes("changeType");
        entry.removeAttributes("modifiersName");
        entry.removeAttributes("modifyTimestamp");
        entry.removeAttributes("m-disabled");
        entry.add("modifiersName", ADMIN_SYSTEM_DN);
        entry.add("modifyTimestamp", DateUtils.getGeneralizedTime());
        FileWriter out = new FileWriter(schemaLdifFile);
        out.write(LdifUtils.convertEntryToLdif(entry));
        out.flush();
        out.close();
        schemaLdifFile = new File(this.baseDirectory, OU_SCHEMA_LDIF);
        reader = new LdifReader(schemaLdifFile);
        ldifEntry = reader.next();
        entry = ldifEntry.getEntry();
        entry.removeAttributes("changeType");
        entry.removeAttributes("modifiersName");
        entry.removeAttributes("modifyTimestamp");
        entry.add("modifiersName", ADMIN_SYSTEM_DN);
        entry.add("modifyTimestamp", DateUtils.getGeneralizedTime());
        out = new FileWriter(schemaLdifFile);
        out.write(LdifUtils.convertEntryToLdif(entry));
        out.flush();
        out.close();
        reader.close();
    }

    private final File getSchemaDirectory(Schema schema) {
        return new File(new File(this.baseDirectory, "ou=schema"), "cn=" + schema.getSchemaName());
    }

    @Override
    public List<Entry> loadComparators(Schema ... schemas) throws Exception {
        ArrayList<Entry> comparatorList = new ArrayList<Entry>();
        if (schemas == null) {
            return comparatorList;
        }
        for (Schema schema : schemas) {
            File[] comparators;
            File comparatorsDirectory = new File(this.getSchemaDirectory(schema), "ou=comparators");
            if (!comparatorsDirectory.exists()) {
                return comparatorList;
            }
            for (File ldifFile : comparators = comparatorsDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                comparatorList.add(entry.getEntry());
            }
        }
        return comparatorList;
    }

    @Override
    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws Exception {
        ArrayList<Entry> syntaxCheckerList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxCheckerList;
        }
        for (Schema schema : schemas) {
            File[] syntaxCheckerFiles;
            File syntaxCheckersDirectory = new File(this.getSchemaDirectory(schema), "ou=syntaxcheckers");
            if (!syntaxCheckersDirectory.exists()) {
                return syntaxCheckerList;
            }
            for (File ldifFile : syntaxCheckerFiles = syntaxCheckersDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                syntaxCheckerList.add(entry.getEntry());
            }
        }
        return syntaxCheckerList;
    }

    @Override
    public List<Entry> loadNormalizers(Schema ... schemas) throws Exception {
        ArrayList<Entry> normalizerList = new ArrayList<Entry>();
        if (schemas == null) {
            return normalizerList;
        }
        for (Schema schema : schemas) {
            File[] normalizerFiles;
            File normalizersDirectory = new File(this.getSchemaDirectory(schema), "ou=normalizers");
            if (!normalizersDirectory.exists()) {
                return normalizerList;
            }
            for (File ldifFile : normalizerFiles = normalizersDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                normalizerList.add(entry.getEntry());
            }
        }
        return normalizerList;
    }

    @Override
    public List<Entry> loadMatchingRules(Schema ... schemas) throws Exception {
        ArrayList<Entry> matchingRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleList;
        }
        for (Schema schema : schemas) {
            File[] matchingRuleFiles;
            File matchingRulesDirectory = new File(this.getSchemaDirectory(schema), "ou=matchingrules");
            if (!matchingRulesDirectory.exists()) {
                return matchingRuleList;
            }
            for (File ldifFile : matchingRuleFiles = matchingRulesDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                matchingRuleList.add(entry.getEntry());
            }
        }
        return matchingRuleList;
    }

    @Override
    public List<Entry> loadSyntaxes(Schema ... schemas) throws Exception {
        ArrayList<Entry> syntaxList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxList;
        }
        for (Schema schema : schemas) {
            File[] syntaxFiles;
            File syntaxesDirectory = new File(this.getSchemaDirectory(schema), "ou=syntaxes");
            if (!syntaxesDirectory.exists()) {
                return syntaxList;
            }
            for (File ldifFile : syntaxFiles = syntaxesDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                syntaxList.add(entry.getEntry());
            }
        }
        return syntaxList;
    }

    @Override
    public List<Entry> loadAttributeTypes(Schema ... schemas) throws Exception {
        ArrayList<Entry> attributeTypeList = new ArrayList<Entry>();
        if (schemas == null) {
            return attributeTypeList;
        }
        for (Schema schema : schemas) {
            File[] attributeTypeFiles;
            File attributeTypesDirectory = new File(this.getSchemaDirectory(schema), "ou=attributetypes");
            if (!attributeTypesDirectory.exists()) {
                return attributeTypeList;
            }
            for (File ldifFile : attributeTypeFiles = attributeTypesDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                attributeTypeList.add(entry.getEntry());
            }
        }
        return attributeTypeList;
    }

    @Override
    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws Exception {
        ArrayList<Entry> matchingRuleUseList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleUseList;
        }
        for (Schema schema : schemas) {
            File[] matchingRuleUseFiles;
            File matchingRuleUsesDirectory = new File(this.getSchemaDirectory(schema), "ou=matchingruleuse");
            if (!matchingRuleUsesDirectory.exists()) {
                return matchingRuleUseList;
            }
            for (File ldifFile : matchingRuleUseFiles = matchingRuleUsesDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                matchingRuleUseList.add(entry.getEntry());
            }
        }
        return matchingRuleUseList;
    }

    @Override
    public List<Entry> loadNameForms(Schema ... schemas) throws Exception {
        ArrayList<Entry> nameFormList = new ArrayList<Entry>();
        if (schemas == null) {
            return nameFormList;
        }
        for (Schema schema : schemas) {
            File[] nameFormFiles;
            File nameFormsDirectory = new File(this.getSchemaDirectory(schema), "ou=nameforms");
            if (!nameFormsDirectory.exists()) {
                return nameFormList;
            }
            for (File ldifFile : nameFormFiles = nameFormsDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                nameFormList.add(entry.getEntry());
            }
        }
        return nameFormList;
    }

    @Override
    public List<Entry> loadDitContentRules(Schema ... schemas) throws Exception {
        ArrayList<Entry> ditContentRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditContentRuleList;
        }
        for (Schema schema : schemas) {
            File[] ditContentRuleFiles;
            File ditContentRulesDirectory = new File(this.getSchemaDirectory(schema), "ou=ditcontentrules");
            if (!ditContentRulesDirectory.exists()) {
                return ditContentRuleList;
            }
            for (File ldifFile : ditContentRuleFiles = ditContentRulesDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                ditContentRuleList.add(entry.getEntry());
            }
        }
        return ditContentRuleList;
    }

    @Override
    public List<Entry> loadDitStructureRules(Schema ... schemas) throws Exception {
        ArrayList<Entry> ditStructureRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditStructureRuleList;
        }
        for (Schema schema : schemas) {
            File[] ditStructureRuleFiles;
            File ditStructureRulesDirectory = new File(this.getSchemaDirectory(schema), "ou=ditstructurerules");
            if (!ditStructureRulesDirectory.exists()) {
                return ditStructureRuleList;
            }
            for (File ldifFile : ditStructureRuleFiles = ditStructureRulesDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                ditStructureRuleList.add(entry.getEntry());
            }
        }
        return ditStructureRuleList;
    }

    @Override
    public List<Entry> loadObjectClasses(Schema ... schemas) throws Exception {
        ArrayList<Entry> objectClassList = new ArrayList<Entry>();
        if (schemas == null) {
            return objectClassList;
        }
        for (Schema schema : schemas) {
            File[] objectClassFiles;
            File objectClassesDirectory = new File(this.getSchemaDirectory(schema), "ou=objectclasses");
            if (!objectClassesDirectory.exists()) {
                return objectClassList;
            }
            for (File ldifFile : objectClassFiles = objectClassesDirectory.listFiles(this.ldifFilter)) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                objectClassList.add(entry.getEntry());
            }
        }
        return objectClassList;
    }
}

