/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci;

import org.apache.directory.api.ldap.aci.MicroOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GrantAndDenial {
    GRANT_ADD(MicroOperation.ADD, 0, true),
    DENY_ADD(MicroOperation.ADD, 1, false),
    GRANT_DISCLOSE_ON_ERROR(MicroOperation.DISCLOSE_ON_ERROR, 2, true),
    DENY_DISCLOSE_ON_ERROR(MicroOperation.DISCLOSE_ON_ERROR, 3, false),
    GRANT_READ(MicroOperation.READ, 4, true),
    DENY_READ(MicroOperation.READ, 5, false),
    GRANT_REMOVE(MicroOperation.REMOVE, 6, true),
    DENY_REMOVE(MicroOperation.REMOVE, 7, false),
    GRANT_BROWSE(MicroOperation.BROWSE, 8, true),
    DENY_BROWSE(MicroOperation.BROWSE, 9, false),
    GRANT_EXPORT(MicroOperation.EXPORT, 10, true),
    DENY_EXPORT(MicroOperation.EXPORT, 11, false),
    GRANT_IMPORT(MicroOperation.IMPORT, 12, true),
    DENY_IMPORT(MicroOperation.IMPORT, 13, false),
    GRANT_MODIFY(MicroOperation.MODIFY, 14, true),
    DENY_MODIFY(MicroOperation.MODIFY, 15, false),
    GRANT_RENAME(MicroOperation.RENAME, 16, true),
    DENY_RENAME(MicroOperation.RENAME, 17, false),
    GRANT_RETURN_DN(MicroOperation.RETURN_DN, 18, true),
    DENY_RETURN_DN(MicroOperation.RETURN_DN, 19, false),
    GRANT_COMPARE(MicroOperation.COMPARE, 20, true),
    DENY_COMPARE(MicroOperation.COMPARE, 21, false),
    GRANT_FILTER_MATCH(MicroOperation.FILTER_MATCH, 22, true),
    DENY_FILTER_MATCH(MicroOperation.FILTER_MATCH, 23, false),
    GRANT_INVOKE(MicroOperation.INVOKE, 24, true),
    DENY_INVOKE(MicroOperation.INVOKE, 25, false);

    private final MicroOperation microOperation;
    private final int code;
    private final String name;
    private final boolean grant;

    private GrantAndDenial(MicroOperation microOperation, int code, boolean grant) {
        this.microOperation = microOperation;
        this.code = code;
        this.name = (grant ? "grant" : "deny") + microOperation.getName();
        this.grant = grant;
    }

    public MicroOperation getMicroOperation() {
        return this.microOperation;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGrant() {
        return this.grant;
    }

    public String toString() {
        return this.name;
    }
}

