/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.Decorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapEncoder;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapResultDecorator
implements LdapResult,
Decorator<LdapResult> {
    private final LdapResult decoratedLdapResult;
    private byte[] errorMessageBytes;
    private byte[] matchedDnBytes;
    private LdapApiService codec;
    private static final byte[] DEFAULT_SUCCESS = new byte[]{10, 1, 0, 4, 0, 4, 0};

    public LdapResultDecorator(LdapResult decoratedLdapResult) {
        this.decoratedLdapResult = decoratedLdapResult;
    }

    public byte[] getErrorMessageBytes() {
        return this.errorMessageBytes;
    }

    public void setErrorMessageBytes(byte[] errorMessageBytes) {
        this.errorMessageBytes = errorMessageBytes;
    }

    public void setMatchedDnBytes(byte[] matchedDnBytes) {
        this.matchedDnBytes = matchedDnBytes;
    }

    public byte[] getMatchedDnBytes() {
        return this.matchedDnBytes;
    }

    @Override
    public ResultCodeEnum getResultCode() {
        return this.decoratedLdapResult.getResultCode();
    }

    @Override
    public void setResultCode(ResultCodeEnum resultCode) {
        this.decoratedLdapResult.setResultCode(resultCode);
    }

    @Override
    public Dn getMatchedDn() {
        return this.decoratedLdapResult.getMatchedDn();
    }

    @Override
    public void setMatchedDn(Dn dn) {
        this.decoratedLdapResult.setMatchedDn(dn);
    }

    @Override
    public String getDiagnosticMessage() {
        return this.decoratedLdapResult.getDiagnosticMessage();
    }

    @Override
    public void setDiagnosticMessage(String diagnosticMessage) {
        this.decoratedLdapResult.setDiagnosticMessage(diagnosticMessage);
    }

    @Override
    public boolean isReferral() {
        return this.decoratedLdapResult.isReferral();
    }

    @Override
    public Referral getReferral() {
        return this.decoratedLdapResult.getReferral();
    }

    @Override
    public void setReferral(Referral referral) {
        this.decoratedLdapResult.setReferral(referral);
    }

    public String toString() {
        return this.decoratedLdapResult.toString();
    }

    @Override
    public int computeLength() {
        if (this.decoratedLdapResult.isDefaultSuccess()) {
            return DEFAULT_SUCCESS.length;
        }
        int ldapResultLength = 0;
        ldapResultLength = 2 + BerValue.getNbBytes(this.getResultCode().getValue());
        if (this.getMatchedDn() == null) {
            ldapResultLength += 2;
        } else {
            byte[] matchedDNBytes = Strings.getBytesUtf8Ascii(Strings.trimLeft(this.getMatchedDn().getName()));
            ldapResultLength += 1 + TLV.getNbBytes(matchedDNBytes.length) + matchedDNBytes.length;
            this.setMatchedDnBytes(matchedDNBytes);
        }
        byte[] errorMessageBytes = Strings.getBytesUtf8Ascii(this.getDiagnosticMessage());
        ldapResultLength += 1 + TLV.getNbBytes(errorMessageBytes.length) + errorMessageBytes.length;
        this.setErrorMessageBytes(errorMessageBytes);
        int referralLength = LdapEncoder.computeReferralLength(this.getReferral());
        if (referralLength != 0) {
            ldapResultLength += 1 + TLV.getNbBytes(referralLength) + referralLength;
        }
        return ldapResultLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        if (this.decoratedLdapResult.isDefaultSuccess()) {
            buffer.put(DEFAULT_SUCCESS);
            return buffer;
        }
        try {
            BerValue.encodeEnumerated(buffer, this.getResultCode().getValue());
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        BerValue.encode(buffer, this.getMatchedDnBytes());
        BerValue.encode(buffer, this.getErrorMessageBytes());
        Referral referral = this.getReferral();
        if (referral != null) {
            LdapEncoder.encodeReferral(buffer, referral);
        }
        return buffer;
    }

    @Override
    public LdapResult getDecorated() {
        return this.decoratedLdapResult;
    }

    @Override
    public LdapApiService getCodecService() {
        return this.codec;
    }

    @Override
    public boolean isDefaultSuccess() {
        return this.decoratedLdapResult.isDefaultSuccess();
    }
}

