/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.net.SocketAddress;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.authn.AbstractAuthenticator;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.session.IoSession;

public class DelegatingAuthenticator
extends AbstractAuthenticator {
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private String delegateHost;
    private int delegatePort;

    public DelegatingAuthenticator() {
        super(AuthenticationLevel.SIMPLE);
    }

    protected DelegatingAuthenticator(AuthenticationLevel type) {
        super(type);
    }

    public String getDelegateHost() {
        return this.delegateHost;
    }

    public void setDelegateHost(String delegateHost) {
        this.delegateHost = delegateHost;
    }

    public int getDelegatePort() {
        return this.delegatePort;
    }

    public void setDelegatePort(int delegatePort) {
        this.delegatePort = delegatePort;
    }

    @Override
    public LdapPrincipal authenticate(BindOperationContext bindContext) throws Exception {
        LdapPrincipal principal = null;
        if (IS_DEBUG) {
            LOG.debug("Authenticating {}", (Object)bindContext.getDn());
        }
        LdapNetworkConnection ldapConnection = new LdapNetworkConnection(this.delegateHost, this.delegatePort);
        try {
            try {
                ldapConnection.bind(bindContext.getDn(), Strings.utf8ToString(bindContext.getCredentials()));
                ldapConnection.unBind();
            }
            catch (LdapException le) {
                String message = I18n.err(I18n.ERR_230, bindContext.getDn().getName());
                LOG.info(message);
                throw new LdapAuthenticationException(message);
            }
            principal = new LdapPrincipal(this.getDirectoryService().getSchemaManager(), bindContext.getDn(), AuthenticationLevel.SIMPLE, bindContext.getCredentials());
            IoSession session = bindContext.getIoSession();
            if (session != null) {
                SocketAddress clientAddress = session.getRemoteAddress();
                principal.setClientAddress(clientAddress);
                SocketAddress serverAddress = session.getServiceAddress();
                principal.setServerAddress(serverAddress);
            }
            return principal;
        }
        catch (LdapException e) {
            String message = I18n.err(I18n.ERR_230, bindContext.getDn().getName());
            LOG.info(message);
            throw new LdapAuthenticationException(message);
        }
    }

    @Override
    public void checkPwdPolicy(Entry userEntry) throws LdapException {
    }

    @Override
    public void invalidateCache(Dn bindDn) {
    }
}

