/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.util.tree.DnNode;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.ReferralManager;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;

public class ReferralManagerImpl
implements ReferralManager {
    private DnNode<Entry> referrals;
    private ReentrantReadWriteLock mutex = new ReentrantReadWriteLock();
    private AttributeType OBJECT_CLASS_AT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferralManagerImpl(DirectoryService directoryService) throws LdapException {
        this.lockWrite();
        try {
            this.referrals = new DnNode();
            PartitionNexus nexus = directoryService.getPartitionNexus();
            Set<String> suffixes = nexus.listSuffixes();
            this.OBJECT_CLASS_AT = directoryService.getSchemaManager().getAttributeType("objectClass");
            this.init(directoryService, suffixes.toArray(new String[0]));
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void lockRead() {
        this.mutex.readLock().lock();
    }

    @Override
    public void lockWrite() {
        this.mutex.writeLock().lock();
    }

    @Override
    public void unlock() {
        if (this.mutex.isWriteLockedByCurrentThread()) {
            this.mutex.writeLock().unlock();
        } else {
            this.mutex.readLock().unlock();
        }
    }

    @Override
    public void addReferral(Entry entry) {
        try {
            this.referrals.add(entry.getDn(), entry);
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(DirectoryService directoryService, String ... suffixes) throws LdapException {
        EqualityNode<String> referralFilter = new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("referral"));
        SearchControls searchControl = new SearchControls();
        searchControl.setReturningObjFlag(false);
        searchControl.setSearchScope(2);
        CoreSession adminSession = directoryService.getAdminSession();
        PartitionNexus nexus = directoryService.getPartitionNexus();
        for (String suffix : suffixes) {
            Dn suffixDn = directoryService.getDnFactory().create(suffix);
            SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, suffixDn, referralFilter, searchControl);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            EntryFilteringCursor cursor = nexus.search(searchOperationContext);
            try {
                cursor.beforeFirst();
                while (cursor.next()) {
                    Entry entry = (Entry)cursor.get();
                    this.lockWrite();
                    try {
                        this.addReferral(entry);
                    }
                    finally {
                        this.unlock();
                    }
                }
                cursor.close();
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void remove(DirectoryService directoryService, Dn suffix) throws Exception {
        EqualityNode<String> referralFilter = new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("referral"));
        SearchControls searchControl = new SearchControls();
        searchControl.setReturningObjFlag(false);
        searchControl.setSearchScope(2);
        CoreSession adminSession = directoryService.getAdminSession();
        PartitionNexus nexus = directoryService.getPartitionNexus();
        SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, suffix, referralFilter, searchControl);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
        EntryFilteringCursor cursor = nexus.search(searchOperationContext);
        cursor.beforeFirst();
        while (cursor.next()) {
            Entry entry = (Entry)cursor.get();
            this.removeReferral(entry);
        }
    }

    @Override
    public boolean hasParentReferral(Dn dn) {
        DnNode<Entry> referral = this.referrals.getNode(dn);
        return referral != null && referral.isLeaf();
    }

    @Override
    public Entry getParentReferral(Dn dn) {
        if (!this.hasParentReferral(dn)) {
            return null;
        }
        return this.referrals.getElement(dn);
    }

    @Override
    public boolean isReferral(Dn dn) {
        Entry parent = this.referrals.getElement(dn);
        if (parent != null) {
            return dn.equals(parent.getDn());
        }
        return false;
    }

    @Override
    public void removeReferral(Entry entry) throws LdapException {
        this.referrals.remove(entry.getDn());
    }
}

