/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.impl.ScanCountComparator;

public class AndEvaluator
implements Evaluator<AndNode> {
    private final List<Evaluator<? extends ExprNode>> evaluators;
    private final AndNode node;

    public AndEvaluator(AndNode node, List<Evaluator<? extends ExprNode>> evaluators) {
        this.node = node;
        this.evaluators = this.optimize(evaluators);
    }

    private List<Evaluator<? extends ExprNode>> optimize(List<Evaluator<? extends ExprNode>> unoptimized) {
        ArrayList<Evaluator<? extends ExprNode>> optimized = new ArrayList<Evaluator<? extends ExprNode>>(unoptimized.size());
        optimized.addAll(unoptimized);
        Collections.sort(optimized, new ScanCountComparator());
        return optimized;
    }

    @Override
    public boolean evaluate(Entry entry) throws Exception {
        for (Evaluator<? extends ExprNode> evaluator : this.evaluators) {
            if (evaluator.evaluate(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(IndexEntry<?, String> indexEntry) throws LdapException {
        for (Evaluator<? extends ExprNode> evaluator : this.evaluators) {
            if (evaluator.evaluate(indexEntry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AndNode getExpression() {
        return this.node;
    }

    private String dumpEvaluators(String tabs) {
        StringBuilder sb = new StringBuilder();
        for (Evaluator<? extends ExprNode> evaluator : this.evaluators) {
            sb.append(evaluator.toString(tabs + "  "));
        }
        return sb.toString();
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("AndEvaluator : ").append(this.node).append("\n");
        if (this.evaluators != null && this.evaluators.size() > 0) {
            sb.append(this.dumpEvaluators(tabs + "  ")).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

