/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.template;

import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyDecorator;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.ldap.client.template.PasswordPolicyOperation;
import org.apache.directory.ldap.client.template.PasswordPolicyResponder;
import org.apache.directory.ldap.client.template.PasswordWarning;
import org.apache.directory.ldap.client.template.PasswordWarningImpl;
import org.apache.directory.ldap.client.template.exception.PasswordException;

public class PasswordPolicyResponderImpl
implements PasswordPolicyResponder {
    private final PasswordPolicyDecorator passwordPolicyRequestControl;

    public PasswordPolicyResponderImpl(LdapApiService ldapApiService) {
        this.passwordPolicyRequestControl = new PasswordPolicyDecorator(ldapApiService);
    }

    private PasswordPolicy getPasswordPolicy(Response response) {
        Control control = response.getControls().get(this.passwordPolicyRequestControl.getOid());
        return control == null ? null : (PasswordPolicy)((PasswordPolicyDecorator)control).getDecorated();
    }

    @Override
    public PasswordWarning process(PasswordPolicyOperation operation) throws PasswordException {
        try {
            ResultResponse response = operation.process();
            PasswordPolicy passwordPolicy = this.getPasswordPolicy(response);
            ResultCodeEnum resultCode = response.getLdapResult().getResultCode();
            if (resultCode == ResultCodeEnum.SUCCESS) {
                if (passwordPolicy != null) {
                    return PasswordWarningImpl.newWarning(passwordPolicy);
                }
                return null;
            }
            PasswordException exception = new PasswordException();
            exception.setResultCode(resultCode);
            if (passwordPolicy != null && passwordPolicy.getResponse() != null && passwordPolicy.getResponse().getPasswordPolicyError() != null) {
                exception.setPasswordPolicyError(passwordPolicy.getResponse().getPasswordPolicyError());
            }
            throw exception;
        }
        catch (LdapException e) {
            throw new PasswordException().setLdapException(e);
        }
    }
}

