/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.parsers.AbstractSchemaParser;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.OpenLdapObjectIdentifierMacro;

public class OpenLdapSchemaParser
extends AbstractSchemaParser<SchemaObject> {
    private List<Object> schemaDescriptions;
    private List<MutableAttributeType> attributeTypes;
    private List<ObjectClass> objectClasses;
    private Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros;
    private boolean isResolveObjectIdentifierMacros = true;

    public OpenLdapSchemaParser() throws IOException {
        super(null, null, null, null);
        super.setQuirksMode(true);
    }

    @Override
    protected SchemaObject doParse() throws RecognitionException, TokenStreamException {
        throw new UnsupportedOperationException("OpenLdapSchemaParser is not a normal schema parser");
    }

    public void clear() {
    }

    public List<MutableAttributeType> getAttributeTypes() {
        return this.attributeTypes;
    }

    public List<ObjectClass> getObjectClassTypes() {
        return this.objectClasses;
    }

    public Map<String, OpenLdapObjectIdentifierMacro> getObjectIdentifierMacros() {
        return this.objectIdentifierMacros;
    }

    private void afterParse() throws ParseException {
        this.objectClasses = new ArrayList<ObjectClass>();
        this.attributeTypes = new ArrayList<MutableAttributeType>();
        this.objectIdentifierMacros = new HashMap<String, OpenLdapObjectIdentifierMacro>();
        for (Object obj : this.schemaDescriptions) {
            if (obj instanceof OpenLdapObjectIdentifierMacro) {
                OpenLdapObjectIdentifierMacro oid = (OpenLdapObjectIdentifierMacro)obj;
                this.objectIdentifierMacros.put(oid.getName(), oid);
                continue;
            }
            if (obj instanceof AttributeType) {
                MutableAttributeType attributeType = (MutableAttributeType)obj;
                this.attributeTypes.add(attributeType);
                continue;
            }
            if (!(obj instanceof ObjectClass)) continue;
            ObjectClass objectClass = (ObjectClass)obj;
            this.objectClasses.add(objectClass);
        }
        if (this.isResolveObjectIdentifierMacros()) {
            for (OpenLdapObjectIdentifierMacro oid : this.objectIdentifierMacros.values()) {
                this.resolveObjectIdentifierMacro(oid);
            }
            for (ObjectClass objectClass : this.objectClasses) {
                objectClass.setOid(this.getResolveOid(objectClass.getOid()));
            }
            for (MutableAttributeType attributeType : this.attributeTypes) {
                attributeType.setOid(this.getResolveOid(attributeType.getOid()));
                attributeType.setSyntaxOid(this.getResolveOid(attributeType.getSyntaxOid()));
            }
        }
    }

    private String getResolveOid(String oid) {
        String[] nameAndSuffix;
        if (oid != null && oid.indexOf(58) != -1 && this.objectIdentifierMacros.containsKey((nameAndSuffix = oid.split(":"))[0])) {
            OpenLdapObjectIdentifierMacro macro = this.objectIdentifierMacros.get(nameAndSuffix[0]);
            return macro.getResolvedOid() + "." + nameAndSuffix[1];
        }
        return oid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveObjectIdentifierMacro(OpenLdapObjectIdentifierMacro macro) throws ParseException {
        String rawOidOrNameSuffix = macro.getRawOidOrNameSuffix();
        if (macro.isResolved()) {
            return;
        }
        if (rawOidOrNameSuffix.indexOf(58) != -1) {
            String[] nameAndSuffix = rawOidOrNameSuffix.split(":");
            if (!this.objectIdentifierMacros.containsKey(nameAndSuffix[0])) throw new ParseException(I18n.err(I18n.ERR_04257, nameAndSuffix[0]), 0);
            OpenLdapObjectIdentifierMacro parentMacro = this.objectIdentifierMacros.get(nameAndSuffix[0]);
            this.resolveObjectIdentifierMacro(parentMacro);
            macro.setResolvedOid(parentMacro.getResolvedOid() + "." + nameAndSuffix[1]);
            return;
        } else if (this.objectIdentifierMacros.containsKey(rawOidOrNameSuffix)) {
            OpenLdapObjectIdentifierMacro parentMacro = this.objectIdentifierMacros.get(rawOidOrNameSuffix);
            this.resolveObjectIdentifierMacro(parentMacro);
            macro.setResolvedOid(parentMacro.getResolvedOid());
            return;
        } else {
            macro.setResolvedOid(rawOidOrNameSuffix);
        }
    }

    @Override
    public SchemaObject parse(String schemaObject) throws ParseException {
        if (schemaObject == null || schemaObject.trim().equals("")) {
            throw new ParseException(I18n.err(I18n.ERR_04258, new Object[0]), 0);
        }
        this.reset(schemaObject);
        this.invokeParser(schemaObject);
        if (!this.schemaDescriptions.isEmpty()) {
            for (Object obj : this.schemaDescriptions) {
                if (!(obj instanceof SchemaObject)) continue;
                return (SchemaObject)obj;
            }
        }
        return null;
    }

    private void invokeParser(String subject) throws ParseException {
        try {
            this.monitor.startedParse("starting parse on:\n" + subject);
            this.schemaDescriptions = this.parser.openLdapSchema();
            this.afterParse();
            this.monitor.finishedParse("Done parsing!");
        }
        catch (RecognitionException e) {
            String msg = "Parser failure on:\n\t" + subject;
            msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e);
            throw new ParseException(msg, e.getColumn());
        }
        catch (TokenStreamException e2) {
            String msg = "Parser failure on:\n\t" + subject;
            msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e2);
            throw new ParseException(msg, 0);
        }
    }

    public void parse(InputStream schemaIn) throws IOException, ParseException {
        InputStreamReader in = new InputStreamReader(schemaIn);
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
        this.invokeParser("schema input stream ==> " + schemaIn.toString());
    }

    public void parse(File schemaFile) throws IOException, ParseException {
        FileReader in = new FileReader(schemaFile);
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
        this.invokeParser("schema file ==> " + schemaFile.getAbsolutePath());
    }

    public boolean isResolveObjectIdentifierMacros() {
        return this.isResolveObjectIdentifierMacros;
    }

    public void setResolveObjectIdentifierMacros(boolean resolveObjectIdentifierMacros) {
        this.isResolveObjectIdentifierMacros = resolveObjectIdentifierMacros;
    }
}

