/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.integ.CreateDsRule;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLdapServerRule
extends CreateDsRule {
    private static Logger LOG = LoggerFactory.getLogger(CreateLdapServerRule.class);
    private CreateLdapServerRule classCreateLdapServerRule;
    private LdapServer ldapServer;

    public CreateLdapServerRule() {
        this(null);
    }

    public CreateLdapServerRule(CreateLdapServerRule classCreateLdapServerRule) {
        super(classCreateLdapServerRule);
        this.classCreateLdapServerRule = classCreateLdapServerRule;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        return super.apply(this.buildStatement(base, description), description);
    }

    private Statement buildStatement(final Statement base, final Description description) {
        CreateLdapServer createLdapServer = (CreateLdapServer)description.getAnnotation(CreateLdapServer.class);
        if (createLdapServer == null) {
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    LdapServer ldapServer = CreateLdapServerRule.this.getLdapServer();
                    DirectoryService directoryService = CreateLdapServerRule.this.getDirectoryService();
                    if (ldapServer != null && directoryService != ldapServer.getDirectoryService()) {
                        LOG.trace("Changing to new directory service");
                        DirectoryService oldDirectoryService = ldapServer.getDirectoryService();
                        ldapServer.setDirectoryService(directoryService);
                        try {
                            base.evaluate();
                        }
                        finally {
                            LOG.trace("Reverting to old directory service");
                            ldapServer.setDirectoryService(oldDirectoryService);
                        }
                    } else {
                        LOG.trace("no @CreateLdapServer on: {}", (Object)description);
                        base.evaluate();
                    }
                }
            };
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                LOG.trace("Creating ldap server");
                CreateLdapServerRule.this.ldapServer = ServerAnnotationProcessor.createLdapServer(description, CreateLdapServerRule.this.getDirectoryService());
                try {
                    base.evaluate();
                }
                finally {
                    LOG.trace("Stopping ldap server");
                    CreateLdapServerRule.this.ldapServer.stop();
                }
            }
        };
    }

    public LdapServer getLdapServer() {
        return this.ldapServer == null ? (this.classCreateLdapServerRule == null ? null : this.classCreateLdapServerRule.getLdapServer()) : this.ldapServer;
    }
}

