/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import jdbm.RecordManager;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import jdbm.recman.TransactionManager;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.exception.MultiException;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmDnIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmRdnIndex;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmPartition
extends AbstractBTreePartition {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmPartition.class);
    private static final String JDBM_DB_FILE_EXTN = ".db";
    private static final FilenameFilter DB_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(JdbmPartition.JDBM_DB_FILE_EXTN) && !name.startsWith("master.");
        }
    };
    private RecordManager recMan;
    private Cache entryCache;

    public JdbmPartition(SchemaManager schemaManager, DnFactory dnFactory) {
        super(schemaManager, dnFactory);
        if (this.cacheSize < 0) {
            this.cacheSize = 10000;
            LOG.debug("Using the default entry cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        } else {
            LOG.debug("Using the custom configured cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
        }
    }

    @Override
    protected void doInit() throws Exception {
        if (!this.initialized) {
            if (!this.optimizerEnabled) {
                this.setOptimizer(new NoOpOptimizer());
            } else {
                this.setOptimizer(new DefaultOptimizer(this));
            }
            EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this, this.schemaManager);
            CursorBuilder cursorBuilder = new CursorBuilder(this, evaluatorBuilder);
            this.setSearchEngine(new DefaultSearchEngine(this, cursorBuilder, evaluatorBuilder, this.getOptimizer()));
            File partitionDir = new File(this.getPartitionPath());
            if (!partitionDir.exists() && !partitionDir.mkdirs()) {
                throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, partitionDir));
            }
            File[] allIndexDbFiles = partitionDir.listFiles(DB_FILTER);
            List<String> indexDbFileNameList = Arrays.asList(partitionDir.list(DB_FILTER));
            ArrayList<String> allIndices = new ArrayList<String>();
            ArrayList indexToBuild = new ArrayList();
            for (Index<?, String> index : this.getIndexedAttributes()) {
                String oid = this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()).getOid();
                allIndices.add(oid);
                String name = oid + JDBM_DB_FILE_EXTN;
                if (indexDbFileNameList.contains(name)) continue;
                indexToBuild.add(index);
            }
            super.doInit();
            String path = partitionDir.getPath() + File.separator + "master";
            BaseRecordManager base = new BaseRecordManager(path);
            TransactionManager transactionManager = base.getTransactionManager();
            transactionManager.setMaximumTransactionsInLog(2000);
            if (this.cacheSize < 0) {
                this.cacheSize = 10000;
                LOG.debug("Using the default entry cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
            } else {
                LOG.debug("Using the custom configured cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.id);
            }
            String cacheSizeVal = System.getProperty("jdbm.recman.cache.size", "100");
            int recCacheSize = Integer.parseInt(cacheSizeVal);
            LOG.info("Setting CacheRecondManager's cache size to {}", (Object)recCacheSize);
            this.recMan = new CacheRecordManager(base, new MRU<Long, CacheRecordManager.CacheEntry>(recCacheSize));
            this.master = new JdbmMasterTable(this.recMan, this.schemaManager);
            if (indexToBuild.size() > 0) {
                this.buildUserIndex(indexToBuild);
            }
            this.deleteUnusedIndexFiles(allIndices, allIndexDbFiles);
            if (this.cacheService != null) {
                this.entryCache = this.cacheService.getCache(this.getId());
                int cacheSizeConfig = this.entryCache.getCacheConfiguration().getMaxElementsInMemory();
                if (cacheSizeConfig < this.cacheSize) {
                    this.entryCache.getCacheConfiguration().setMaxElementsInMemory(this.cacheSize);
                }
            }
            if (this.suffixDn != null && this.contextEntry != null) {
                Entry suffixEntry;
                Dn contextEntryDn = this.contextEntry.getDn();
                if (!contextEntryDn.isSchemaAware()) {
                    contextEntryDn.apply(this.schemaManager);
                }
                if (this.suffixDn.equals(contextEntryDn) && (suffixEntry = this.lookup(new LookupOperationContext(null, this.suffixDn))) == null) {
                    if (!this.contextEntry.isSchemaAware()) {
                        this.contextEntry = new DefaultEntry(this.schemaManager, this.contextEntry);
                    }
                    if (this.contextEntry.get("entryCSN") == null) {
                        this.contextEntry.add("entryCSN", new CsnFactory(0).newInstance().toString());
                    }
                    if (this.contextEntry.get("entryUUID") == null) {
                        String uuid = UUID.randomUUID().toString();
                        this.contextEntry.add("entryUUID", uuid);
                    }
                    this.add(new AddOperationContext(null, this.contextEntry));
                }
            }
            this.initialized = true;
        }
    }

    public String getDefaultId() {
        return Partition.DEFAULT_ID;
    }

    public String getRootId() {
        return Partition.ROOT_ID;
    }

    @Override
    public synchronized void sync() throws Exception {
        if (!this.initialized) {
            return;
        }
        for (Index idx : this.systemIndices.values()) {
            idx.sync();
        }
        for (Index idx : this.userIndices.values()) {
            idx.sync();
        }
        ((JdbmMasterTable)this.master).sync();
    }

    private void buildUserIndex(List<Index<?, String>> indices) throws Exception {
        Cursor cursor = this.master.cursor();
        cursor.beforeFirst();
        while (cursor.next()) {
            for (Index<?, String> index : indices) {
                AttributeType atType = index.getAttribute();
                String attributeOid = index.getAttribute().getOid();
                if (this.systemIndices.get(attributeOid) != null) continue;
                LOG.info("building the index for attribute type {}", (Object)atType);
                Tuple tuple = cursor.get();
                String id = (String)tuple.getKey();
                Entry entry = (Entry)tuple.getValue();
                Attribute entryAttr = entry.get(atType);
                if (entryAttr == null) continue;
                for (Value value : entryAttr) {
                    index.add(value.getNormValue(), id);
                }
                this.presenceIdx.add(attributeOid, id);
            }
        }
        cursor.close();
    }

    private void deleteUnusedIndexFiles(List<String> allIndices, File[] dbFiles) {
        for (File file : dbFiles) {
            String name = file.getName();
            if (this.systemIndices.get(name = name.substring(0, name.lastIndexOf(JDBM_DB_FILE_EXTN))) != null || allIndices.contains(name)) continue;
            boolean deleted = file.delete();
            if (deleted) {
                LOG.info("Deleted unused index file {}", (Object)file.getAbsolutePath());
                try {
                    String atName = this.schemaManager.lookupAttributeTypeRegistry(name).getName();
                    File txtFile = new File(file.getParent(), name + "-" + atName + ".txt");
                    deleted = txtFile.delete();
                    if (deleted) continue;
                    LOG.info("couldn't delete the index name helper file {}", (Object)txtFile);
                }
                catch (Exception e) {
                    LOG.warn("couldn't find the attribute's name with oid {}", (Object)name);
                    LOG.warn("", e);
                }
                continue;
            }
            LOG.warn("Failed to delete unused index file {}", (Object)file.getAbsolutePath());
        }
    }

    @Override
    protected Index<?, String> convertAndInit(Index<?, String> index) throws Exception {
        JdbmIndex jdbmIndex;
        if (index instanceof JdbmRdnIndex) {
            jdbmIndex = (JdbmRdnIndex)index;
        } else if (index instanceof JdbmDnIndex) {
            jdbmIndex = (JdbmDnIndex)index;
        } else if (index instanceof JdbmIndex) {
            jdbmIndex = (JdbmIndex)index;
            if (jdbmIndex.getWkDirPath() == null) {
                jdbmIndex.setWkDirPath(this.partitionPath);
            }
        } else {
            LOG.debug("Supplied index {} is not a JdbmIndex.  Will create new JdbmIndex using copied configuration parameters.", (Object)index);
            jdbmIndex = new JdbmIndex(index.getAttributeId(), true);
            jdbmIndex.setCacheSize(index.getCacheSize());
            jdbmIndex.setNumDupLimit(512);
            jdbmIndex.setWkDirPath(index.getWkDirPath());
        }
        jdbmIndex.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()));
        return jdbmIndex;
    }

    @Override
    protected synchronized void doDestroy() throws Exception {
        MultiException errors = new MultiException(I18n.err(I18n.ERR_577, new Object[0]));
        if (!this.initialized) {
            return;
        }
        try {
            super.doDestroy();
        }
        catch (Exception e) {
            errors.addThrowable(e);
        }
        try {
            this.recMan.close();
            LOG.debug("Closed record manager for {} partition.", (Object)this.suffixDn);
        }
        catch (Throwable t) {
            LOG.error(I18n.err(I18n.ERR_127, new Object[0]), t);
            errors.addThrowable(t);
        }
        finally {
            if (this.entryCache != null) {
                this.entryCache.removeAll();
            }
        }
        if (errors.size() > 0) {
            throw errors;
        }
    }

    @Override
    protected final Index createSystemIndex(String oid, URI path, boolean withReverse) throws Exception {
        JdbmIndex jdbmIndex;
        LOG.debug("Supplied index {} is not a JdbmIndex.  Will create new JdbmIndex using copied configuration parameters.");
        if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
            jdbmIndex = new JdbmRdnIndex();
            jdbmIndex.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.50");
            jdbmIndex.setNumDupLimit(512);
        } else if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
            jdbmIndex = new JdbmDnIndex("1.3.6.1.4.1.18060.0.4.1.2.7");
            jdbmIndex.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.7");
            jdbmIndex.setNumDupLimit(512);
        } else {
            jdbmIndex = new JdbmIndex(oid, withReverse);
            jdbmIndex.setNumDupLimit(512);
        }
        jdbmIndex.setWkDirPath(path);
        return jdbmIndex;
    }

    @Override
    public void updateCache(OperationContext opCtx) {
        if (this.entryCache == null) {
            return;
        }
        try {
            if (opCtx instanceof ModifyOperationContext) {
                ModifyOperationContext modCtx = (ModifyOperationContext)opCtx;
                Entry entry = modCtx.getAlteredEntry();
                String id = entry.get("entryUUID").getString();
                if (entry instanceof ClonedServerEntry) {
                    entry = ((ClonedServerEntry)entry).getOriginalEntry();
                }
                this.entryCache.replace(new Element((Serializable)((Object)id), entry));
            } else if (opCtx instanceof MoveOperationContext || opCtx instanceof MoveAndRenameOperationContext || opCtx instanceof RenameOperationContext) {
                this.entryCache.removeAll();
            } else if (opCtx instanceof DeleteOperationContext) {
                DeleteOperationContext delCtx = (DeleteOperationContext)opCtx;
                this.entryCache.remove((Serializable)((Object)delCtx.getEntry().get("entryUUID").getString()));
            }
        }
        catch (LdapException e) {
            LOG.warn("Failed to update entry cache", e);
        }
    }

    @Override
    public Entry lookupCache(String id) {
        if (this.entryCache == null) {
            return null;
        }
        Element el = this.entryCache.get((Serializable)((Object)id));
        if (el != null) {
            return (Entry)el.getValue();
        }
        return null;
    }

    @Override
    public void addToCache(String id, Entry entry) {
        if (this.entryCache == null) {
            return;
        }
        if (entry instanceof ClonedServerEntry) {
            entry = ((ClonedServerEntry)entry).getOriginalEntry();
        }
        this.entryCache.put(new Element((Serializable)((Object)id), entry));
    }
}

