/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncFlag;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncContainer;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncStatesEnum;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdDirSyncGrammar
extends AbstractGrammar<AdDirSyncContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AdDirSyncGrammar.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final AdDirSyncGrammar INSTANCE = new AdDirSyncGrammar();

    private AdDirSyncGrammar() {
        this.setName(AdDirSyncGrammar.class.getName());
        this.transitions = new GrammarTransition[AdDirSyncStatesEnum.LAST_AD_DIR_SYNC_STATE.ordinal()][256];
        this.transitions[AdDirSyncStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<AdDirSyncContainer>(AdDirSyncStatesEnum.START_STATE, AdDirSyncStatesEnum.AD_DIR_SYNC_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<AdDirSyncContainer>("Initialization"){

            @Override
            public void action(AdDirSyncContainer container) throws DecoderException {
            }
        });
        this.transitions[AdDirSyncStatesEnum.AD_DIR_SYNC_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<AdDirSyncContainer>(AdDirSyncStatesEnum.AD_DIR_SYNC_SEQUENCE_STATE, AdDirSyncStatesEnum.FLAG_STATE, UniversalTag.INTEGER.getValue(), new GrammarAction<AdDirSyncContainer>("Set AdDirSyncControl parentFirst"){

            @Override
            public void action(AdDirSyncContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int flagValue = IntegerDecoder.parse(value);
                    AdDirSyncFlag flag = AdDirSyncFlag.getFlag(flagValue);
                    if (flag == null) {
                        String msg = "Error while decoding the AdDirSync flag, unknown value : " + flagValue;
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                    if (IS_DEBUG) {
                        LOG.debug("flag = {}", (Object)flagValue);
                    }
                    container.getAdDirSyncControl().setFlag(flag);
                }
                catch (IntegerDecoderException ide) {
                    String msg = "Error while decoding the AdDirSync flag : " + ide.getMessage();
                    LOG.error(msg, ide);
                    throw new DecoderException(msg, ide);
                }
            }
        });
        this.transitions[AdDirSyncStatesEnum.FLAG_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<AdDirSyncContainer>(AdDirSyncStatesEnum.FLAG_STATE, AdDirSyncStatesEnum.MAX_RETURN_LENGTH_STATE, UniversalTag.INTEGER.getValue(), new GrammarAction<AdDirSyncContainer>("Set AdDirSyncControl maxReturnLength"){

            @Override
            public void action(AdDirSyncContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int maxReturnLength = IntegerDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("maxReturnLength = {}", (Object)maxReturnLength);
                    }
                    container.getAdDirSyncControl().setMaxReturnLength(maxReturnLength);
                }
                catch (IntegerDecoderException ide) {
                    String msg = "Error while decoding the AdDirSync maxReturnLength : " + ide.getMessage();
                    LOG.error(msg, ide);
                    throw new DecoderException(msg, ide);
                }
            }
        });
        this.transitions[AdDirSyncStatesEnum.MAX_RETURN_LENGTH_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<AdDirSyncContainer>(AdDirSyncStatesEnum.MAX_RETURN_LENGTH_STATE, AdDirSyncStatesEnum.COOKIE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<AdDirSyncContainer>("Set AdDirSyncControl cookie"){

            @Override
            public void action(AdDirSyncContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = {}", (Object)Strings.dumpBytes(cookie));
                }
                container.getAdDirSyncControl().setCookie(cookie);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<AdDirSyncContainer> getInstance() {
        return INSTANCE;
    }
}

