/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.ldif;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.UUID;
import javax.naming.InvalidNameException;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileLdifPartition
extends AbstractLdifPartition {
    private RandomAccessFile ldifFile;
    private volatile boolean enableRewriting = true;
    private boolean dirty = false;
    private Object lock = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(SingleFileLdifPartition.class);

    public SingleFileLdifPartition(SchemaManager schemaManager, DnFactory dnFactory) {
        super(schemaManager, dnFactory);
    }

    @Override
    protected void doInit() throws InvalidNameException, Exception {
        if (!this.initialized) {
            if (this.getPartitionPath() == null) {
                throw new IllegalArgumentException("Partition path cannot be null");
            }
            File partitionFile = new File(this.getPartitionPath());
            if (partitionFile.exists() && !partitionFile.isFile()) {
                throw new IllegalArgumentException("Partition path must be a LDIF file");
            }
            this.ldifFile = new RandomAccessFile(partitionFile, "rws");
            LOG.debug("id is : {}", (Object)this.getId());
            if (this.suffixDn == null || this.suffixDn.isEmpty()) {
                String msg = I18n.err(I18n.ERR_150, new Object[0]);
                LOG.error(msg);
                throw new LdapInvalidDnException(msg);
            }
            this.suffixDn.apply(this.schemaManager);
            super.doInit();
            this.loadEntries();
        }
    }

    private void loadEntries() throws Exception {
        RandomAccessLdifReader parser = new RandomAccessLdifReader();
        Iterator<LdifEntry> itr = parser.iterator();
        if (!itr.hasNext()) {
            parser.close();
            return;
        }
        LdifEntry ldifEntry = itr.next();
        this.contextEntry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
        if (this.suffixDn.equals(this.contextEntry.getDn())) {
            this.addMandatoryOpAt(this.contextEntry);
            AddOperationContext addContext = new AddOperationContext(null, this.contextEntry);
            super.add(addContext);
        } else {
            parser.close();
            throw new LdapException("The given LDIF file doesn't contain the context entry");
        }
        while (itr.hasNext()) {
            ldifEntry = itr.next();
            DefaultEntry entry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
            this.addMandatoryOpAt(entry);
            AddOperationContext addContext = new AddOperationContext(null, entry);
            super.add(addContext);
        }
        parser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            super.add(addContext);
            if (this.contextEntry == null && (entry = addContext.getEntry()).getDn().equals(this.suffixDn)) {
                this.contextEntry = entry;
            }
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            try {
                Entry modifiedEntry = super.modify(modifyContext.getDn(), modifyContext.getModItems().toArray(new Modification[0]));
                modifiedEntry.removeAttributes(this.entryDnAT);
                modifyContext.setAlteredEntry(modifiedEntry);
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.rename(renameContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.move(moveContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.moveAndRename(opContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry delete(String id) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            Entry deletedEntry = super.delete(id);
            this.dirty = true;
            this.rewritePartitionData();
            return deletedEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewritePartitionData() throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.enableRewriting || !this.dirty) {
                return;
            }
            try {
                this.ldifFile.setLength(0L);
                String suffixId = this.getEntryId(this.suffixDn);
                if (suffixId == null) {
                    this.contextEntry = null;
                    return;
                }
                ParentIdAndRdn suffixEntry = (ParentIdAndRdn)this.rdnIdx.reverseLookup(suffixId);
                if (suffixEntry != null) {
                    Entry entry = (Entry)this.master.get(suffixId);
                    entry.removeAttributes(this.entryDnAT);
                    entry.setDn(this.suffixDn);
                    this.appendLdif(entry);
                    this.appendRecursive(suffixId, suffixEntry.getNbChildren());
                }
                this.dirty = false;
            }
            catch (LdapException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LdapException(e);
            }
        }
    }

    private void appendRecursive(String id, int nbSibbling) throws Exception {
        Cursor cursor = this.rdnIdx.forwardCursor();
        IndexEntry startingPos = new IndexEntry();
        startingPos.setKey(new ParentIdAndRdn(id, (Rdn[])null));
        cursor.before(startingPos);
        for (int countChildren = 0; cursor.next() && countChildren < nbSibbling; ++countChildren) {
            IndexEntry element = cursor.get();
            String childId = (String)element.getId();
            Entry entry = this.fetch(childId);
            entry.removeAttributes("entryDN");
            this.appendLdif(entry);
            int nbChildren = ((ParentIdAndRdn)element.getKey()).getNbChildren();
            if (nbChildren <= 0) continue;
            this.appendRecursive(childId, nbChildren);
        }
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLdif(Entry entry) throws IOException, LdapException {
        Object object = this.lock;
        synchronized (object) {
            String ldif = LdifUtils.convertToLdif(entry);
            this.ldifFile.write(Strings.getBytesUtf8(ldif + "\n"));
        }
    }

    private void addMandatoryOpAt(Entry entry) throws LdapException {
        if (entry.get("entryCSN") == null) {
            entry.add("entryCSN", defaultCSNFactory.newInstance().toString());
        }
        if (entry.get("entryUUID") == null) {
            String uuid = UUID.randomUUID().toString();
            entry.add("entryUUID", uuid);
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        super.doDestroy();
        this.ldifFile.close();
    }

    public void setEnableRewriting(boolean enableRewriting) throws LdapException {
        this.enableRewriting = enableRewriting;
        this.rewritePartitionData();
    }

    private class RandomAccessLdifReader
    extends LdifReader {
        private long len;

        public RandomAccessLdifReader() throws LdapException {
            try {
                this.len = SingleFileLdifPartition.this.ldifFile.length();
            }
            catch (IOException e) {
                LdapException le = new LdapException(e.getMessage(), e);
                le.initCause(e);
                throw le;
            }
        }

        @Override
        protected String getLine() throws IOException {
            if (this.len == 0L) {
                return null;
            }
            return SingleFileLdifPartition.this.ldifFile.readLine();
        }
    }
}

