/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.store;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.messages.HardwareAddress;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.service.Lease;
import org.apache.directory.server.dhcp.store.AbstractDhcpStore;
import org.apache.directory.server.dhcp.store.DhcpConfigElement;
import org.apache.directory.server.dhcp.store.Host;
import org.apache.directory.server.dhcp.store.Subnet;

public class SimpleDhcpStore
extends AbstractDhcpStore {
    private Map leases = new HashMap();
    private List subnets = new ArrayList();

    public SimpleDhcpStore() {
        try {
            this.subnets.add(new Subnet(InetAddress.getByName("192.168.168.0"), InetAddress.getByName("255.255.255.0"), InetAddress.getByName("192.168.168.159"), InetAddress.getByName("192.168.168.179")));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Can't init", e);
        }
    }

    protected DirContext getContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:389/dc=tcat,dc=test");
        return new InitialDirContext(env);
    }

    @Override
    protected Lease findExistingLease(HardwareAddress hardwareAddress, Lease existingLease) {
        if (this.leases.containsKey(hardwareAddress)) {
            existingLease = (Lease)this.leases.get(hardwareAddress);
        }
        return existingLease;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Host findDesignatedHost(HardwareAddress hardwareAddress) throws DhcpException {
        try (DirContext ctx = this.getContext();){
            String filter = "(&(objectclass=ipHost)(objectclass=ieee802Device)(macaddress={0}))";
            SearchControls sc = new SearchControls();
            sc.setCountLimit(1L);
            sc.setSearchScope(2);
            NamingEnumeration<SearchResult> ne = ctx.search("", filter, new Object[]{hardwareAddress.toString()}, sc);
            if (!ne.hasMoreElements()) return null;
            SearchResult sr = ne.next();
            Attributes att = sr.getAttributes();
            Attribute ipHostNumberAttribute = att.get("iphostnumber");
            if (ipHostNumberAttribute == null) return null;
            InetAddress clientAddress = InetAddress.getByName((String)ipHostNumberAttribute.get());
            Attribute cnAttribute = att.get("cn");
            Host host = new Host(cnAttribute != null ? (String)cnAttribute.get() : "unknown", clientAddress, hardwareAddress);
            return host;
        }
        catch (NamingException e) {
            throw new DhcpException("Can't lookup lease", e);
        }
    }

    @Override
    protected Subnet findSubnet(InetAddress clientAddress) {
        for (Subnet subnet : this.subnets) {
            if (!subnet.contains(clientAddress)) continue;
            return subnet;
        }
        return null;
    }

    @Override
    public void updateLease(Lease lease) {
        this.leases.put(lease.getHardwareAddress(), lease);
    }

    @Override
    protected OptionsField getOptions(DhcpConfigElement element) {
        return element.getOptions();
    }

    @Override
    protected Map getProperties(DhcpConfigElement element) {
        return element.getProperties();
    }
}

