/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.collective;

import java.util.HashSet;
import java.util.List;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaUtils;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.FilteringOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectiveAttributeInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(CollectiveAttributeInterceptor.class);
    private final EntryFilter searchFilter = new CollectiveAttributeFilter();

    public CollectiveAttributeInterceptor() {
        super(InterceptorEnum.COLLECTIVE_ATTRIBUTE_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        LOG.debug("CollectiveAttribute interceptor initialized");
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        this.checkAdd(addContext.getDn(), addContext.getEntry());
        this.next(addContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Entry result = this.next(lookupContext);
        if (lookupContext.isSyncreplLookup()) {
            return result;
        }
        this.addCollectiveAttributes(lookupContext, result);
        return result;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        this.checkModify(modifyContext);
        this.next(modifyContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(searchContext);
        if (!searchContext.isSyncreplSearch()) {
            cursor.addEntryFilter(this.searchFilter);
        }
        return cursor;
    }

    private void checkAdd(Dn normName, Entry entry) throws LdapException {
        if (entry.hasObjectClass("collectiveAttributeSubentry")) {
            for (Attribute attribute : entry) {
                if (!attribute.getAttributeType().isCollective()) continue;
                return;
            }
            LOG.info("A CollectiveAttribute subentry *should* have at least one collectiveAttribute");
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_257_COLLECTIVE_SUBENTRY_WITHOUT_COLLECTIVE_AT, new Object[0]));
        }
        if (this.containsAnyCollectiveAttributes(entry)) {
            LOG.info("Cannot add the entry {} : it contains some CollectiveAttributes and is not a collective subentry", (Object)entry);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_241_CANNOT_STORE_COLLECTIVE_ATT_IN_ENTRY, new Object[0]));
        }
    }

    private void checkModify(ModifyOperationContext modifyContext) throws LdapException {
        List<Modification> mods = modifyContext.getModItems();
        Entry originalEntry = modifyContext.getEntry();
        Entry targetEntry = SchemaUtils.getTargetEntry(mods, originalEntry);
        if (targetEntry.contains(this.directoryService.getAtProvider().getObjectClass(), "collectiveAttributeSubentry")) {
            return;
        }
        if (this.hasCollectiveAttributes(mods)) {
            LOG.info("Cannot modify the entry {} : it contains some CollectiveAttributes and is not a collective subentry", (Object)targetEntry);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_242, new Object[0]));
        }
    }

    private boolean hasCollectiveAttributes(List<Modification> mods) throws LdapException {
        for (Modification mod : mods) {
            Attribute attr = mod.getAttribute();
            AttributeType attrType = attr.getAttributeType();
            if (attrType == null) {
                try {
                    attrType = this.schemaManager.lookupAttributeTypeRegistry(attr.getUpId());
                }
                catch (LdapException le) {
                    throw new LdapInvalidAttributeTypeException();
                }
            }
            ModificationOperation modOp = mod.getOperation();
            if (!attrType.isCollective() || modOp == ModificationOperation.REMOVE_ATTRIBUTE) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnyCollectiveAttributes(Entry entry) throws LdapException {
        for (Attribute attribute : entry.getAttributes()) {
            AttributeType attributeType = attribute.getAttributeType();
            if (!attributeType.isCollective()) continue;
            return true;
        }
        return false;
    }

    private void addCollectiveAttributes(FilteringOperationContext opContext, Entry entry) throws LdapException {
        CoreSession session = opContext.getSession();
        Attribute collectiveAttributeSubentries = ((ClonedServerEntry)entry).getOriginalEntry().get(this.directoryService.getAtProvider().getCollectiveAttributeSubentries());
        if (collectiveAttributeSubentries == null) {
            return;
        }
        LOG.debug("Filtering entry " + entry.getDn());
        Attribute collectiveExclusions = ((ClonedServerEntry)entry).getOriginalEntry().get(this.directoryService.getAtProvider().getCollectiveExclusions());
        HashSet<AttributeType> exclusions = new HashSet<AttributeType>();
        if (collectiveExclusions != null) {
            LOG.debug("The entry has some exclusions : {}", (Object)collectiveExclusions);
            if (collectiveExclusions.contains("2.5.18.0") || collectiveExclusions.contains("excludeAllCollectiveAttributes")) {
                LOG.debug("The entry excludes all the collectiveAttributes");
                return;
            }
            for (Value value : collectiveExclusions) {
                AttributeType attrType = this.schemaManager.lookupAttributeTypeRegistry(value.getString());
                exclusions.add(attrType);
                LOG.debug("Adding {} in the list of excluded collectiveAttributes", (Object)attrType.getName());
            }
        }
        for (Value value : collectiveAttributeSubentries) {
            String subentryDnStr = value.getString();
            Dn subentryDn = this.dnFactory.create(subentryDnStr);
            LOG.debug("Applying subentries {}", (Object)subentryDn.getName());
            LookupOperationContext lookupContext = new LookupOperationContext(session, subentryDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            Entry subentry = this.directoryService.getPartitionNexus().lookup(lookupContext);
            for (Attribute attribute : subentry.getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                if (!attributeType.isCollective()) continue;
                if (exclusions.contains(attributeType)) {
                    LOG.debug("The {} subentry attribute has been removed, it's in the exclusion list", (Object)attributeType.getName());
                    continue;
                }
                if (!opContext.isAllUserAttributes() && !opContext.contains(this.schemaManager, attributeType)) {
                    LOG.debug("The {} subentry attribute is not in the list of attributes to return", (Object)attributeType.getName());
                    continue;
                }
                Attribute subentryColAttr = subentry.get(attributeType);
                Attribute entryColAttr = entry.get(attributeType);
                if (entryColAttr == null) {
                    entryColAttr = new DefaultAttribute(attributeType);
                    entry.put(entryColAttr);
                }
                for (Value subentryColVal : subentryColAttr) {
                    LOG.debug("Adding the {} collective attribute into the entry", (Object)subentryColAttr);
                    entryColAttr.add(subentryColVal.getString());
                }
            }
        }
    }

    private class CollectiveAttributeFilter
    implements EntryFilter {
        private CollectiveAttributeFilter() {
        }

        @Override
        public boolean accept(SearchOperationContext operation, Entry entry) throws LdapException {
            CollectiveAttributeInterceptor.this.addCollectiveAttributes(operation, entry);
            return true;
        }

        @Override
        public String toString(String tabs) {
            return tabs + "CollectiveAttributeFilter";
        }
    }
}

