/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import java.net.URI;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndex;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.impl.avl.AvlTable;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class AvlIndex<K, O>
extends AbstractIndex<K, O, Long> {
    protected Normalizer normalizer;
    protected AvlTable<K, Long> forward;
    protected AvlTable<Long, K> reverse;

    public AvlIndex() {
    }

    public AvlIndex(String attributeId) {
        super(attributeId);
    }

    public void init(SchemaManager schemaManager, AttributeType attributeType) throws Exception {
        this.attributeType = attributeType;
        MatchingRule mr = attributeType.getEquality();
        if (mr == null) {
            mr = attributeType.getOrdering();
        }
        if (mr == null) {
            mr = attributeType.getSubstring();
        }
        this.normalizer = mr.getNormalizer();
        if (this.normalizer == null) {
            throw new Exception(I18n.err(I18n.ERR_212, attributeType));
        }
        LdapComparator<? super Object> comp = mr.getLdapComparator();
        this.forward = new AvlTable<Object, Long>(attributeType.getName(), comp, LongComparator.INSTANCE, true);
        this.reverse = attributeType.isSingleValued() ? new AvlTable<Long, Object>(attributeType.getName(), LongComparator.INSTANCE, comp, false) : new AvlTable<Long, Object>(attributeType.getName(), LongComparator.INSTANCE, comp, true);
    }

    @Override
    public void add(K attrVal, Long id) throws Exception {
        this.forward.put(this.getNormalized(attrVal), id);
        this.reverse.put(id, (Long)this.getNormalized(attrVal));
    }

    @Override
    public void close() throws Exception {
        if (this.forward != null) {
            this.forward.close();
        }
        if (this.reverse != null) {
            this.reverse.close();
        }
    }

    @Override
    public int count() throws Exception {
        return this.forward.count();
    }

    @Override
    public int count(K attrVal) throws Exception {
        return this.forward.count(this.getNormalized(attrVal));
    }

    @Override
    public void drop(Long id) throws Exception {
        Cursor<Tuple<Long, K>> cursor = this.reverse.cursor(id);
        while (cursor.next()) {
            Tuple<Long, K> tuple = cursor.get();
            this.forward.remove(tuple.getValue(), id);
        }
        this.reverse.remove(id);
    }

    @Override
    public void drop(K attrVal, Long id) throws Exception {
        this.forward.remove(this.getNormalized(attrVal), id);
        this.reverse.remove(id, (Long)this.getNormalized(attrVal));
    }

    @Override
    public boolean forward(K attrVal) throws Exception {
        return this.forward.has(this.getNormalized(attrVal));
    }

    @Override
    public boolean forward(K attrVal, Long id) throws Exception {
        return this.forward.has(this.getNormalized(attrVal), id);
    }

    @Override
    public IndexCursor<K, O, Long> forwardCursor() throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(), true);
    }

    @Override
    public IndexCursor<K, O, Long> forwardCursor(K key) throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(key), true);
    }

    @Override
    public boolean forwardGreaterOrEq(K attrVal) throws Exception {
        return this.forward.hasGreaterOrEqual(this.getNormalized(attrVal));
    }

    @Override
    public boolean forwardGreaterOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasGreaterOrEqual(this.getNormalized(attrVal), id);
    }

    @Override
    public boolean forwardLessOrEq(K attrVal) throws Exception {
        return this.forward.hasLessOrEqual(this.getNormalized(attrVal));
    }

    @Override
    public boolean forwardLessOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasLessOrEqual(this.getNormalized(attrVal), id);
    }

    @Override
    public Long forwardLookup(K attrVal) throws Exception {
        return this.forward.get(this.getNormalized(attrVal));
    }

    @Override
    public Cursor<Long> forwardValueCursor(K key) throws Exception {
        return this.forward.valueCursor(key);
    }

    @Override
    public K getNormalized(K attrVal) throws Exception {
        if (attrVal instanceof Long) {
            return attrVal;
        }
        if (attrVal instanceof String) {
            return (K)this.normalizer.normalize((String)attrVal);
        }
        return (K)this.normalizer.normalize(new BinaryValue((byte[])attrVal)).getValue();
    }

    @Override
    public int greaterThanCount(K attrVal) throws Exception {
        return this.forward.greaterThanCount(this.getNormalized(attrVal));
    }

    @Override
    public int lessThanCount(K attrVal) throws Exception {
        return this.forward.lessThanCount(this.getNormalized(attrVal));
    }

    @Override
    public boolean reverse(Long id) throws Exception {
        return this.reverse.has(id);
    }

    @Override
    public boolean reverse(Long id, K attrVal) throws Exception {
        return this.reverse.has(id, (Long)this.getNormalized(attrVal));
    }

    @Override
    public IndexCursor<K, O, Long> reverseCursor() throws Exception {
        return new IndexCursorAdaptor(this.reverse.cursor(), false);
    }

    @Override
    public IndexCursor<K, O, Long> reverseCursor(Long id) throws Exception {
        return new IndexCursorAdaptor(this.reverse.cursor(id), false);
    }

    @Override
    public boolean reverseGreaterOrEq(Long id) throws Exception {
        return this.reverse.hasGreaterOrEqual(id);
    }

    @Override
    public boolean reverseGreaterOrEq(Long id, K attrVal) throws Exception {
        return this.reverse.hasGreaterOrEqual(id, (Long)this.getNormalized(attrVal));
    }

    @Override
    public boolean reverseLessOrEq(Long id) throws Exception {
        return this.reverse.hasLessOrEqual(id);
    }

    @Override
    public boolean reverseLessOrEq(Long id, K attrVal) throws Exception {
        return this.reverse.hasLessOrEqual(id, (Long)this.getNormalized(attrVal));
    }

    @Override
    public K reverseLookup(Long id) throws Exception {
        return this.reverse.get(id);
    }

    @Override
    public Cursor<K> reverseValueCursor(Long id) throws Exception {
        return this.reverse.valueCursor(id);
    }

    @Override
    public void setWkDirPath(URI wkDirPath) {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_213, new Object[0]));
    }

    @Override
    public URI getWkDirPath() {
        return null;
    }

    @Override
    public boolean isDupsEnabled() {
        return this.reverse.isDupsEnabled();
    }

    @Override
    public void sync() throws Exception {
    }
}

