/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.ExprNode;

public class OrCursor<V, ID>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_722, new Object[0]);
    private final List<IndexCursor<V, Entry, ID>> cursors;
    private final List<Evaluator<? extends ExprNode, Entry, ID>> evaluators;
    private final List<Set<ID>> blacklists;
    private int cursorIndex = -1;

    public OrCursor(List<IndexCursor<V, Entry, ID>> cursors, List<Evaluator<? extends ExprNode, Entry, ID>> evaluators) {
        if (cursors.size() <= 1) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_723, new Object[0]));
        }
        this.cursors = cursors;
        this.evaluators = evaluators;
        this.blacklists = new ArrayList<Set<ID>>();
        for (int ii = 0; ii < cursors.size(); ++ii) {
            this.blacklists.add(new HashSet());
        }
        this.cursorIndex = 0;
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.cursorIndex = 0;
        this.cursors.get(this.cursorIndex).beforeFirst();
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.cursorIndex = this.cursors.size() - 1;
        this.cursors.get(this.cursorIndex).afterLast();
        this.setAvailable(false);
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.setAvailable(this.next());
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.setAvailable(this.previous());
    }

    private boolean isBlackListed(ID id) {
        return this.blacklists.get(this.cursorIndex).contains(id);
    }

    private void blackListIfDuplicate(IndexEntry<?, ID> indexEntry) throws Exception {
        for (int ii = 0; ii < this.evaluators.size(); ++ii) {
            if (ii == this.cursorIndex || !this.evaluators.get(ii).evaluate(indexEntry)) continue;
            this.blacklists.get(ii).add(indexEntry.getId());
        }
    }

    @Override
    public boolean previous() throws Exception {
        IndexEntry candidate;
        while (this.cursors.get(this.cursorIndex).previous()) {
            this.checkNotClosed("previous()");
            candidate = (IndexEntry)this.cursors.get(this.cursorIndex).get();
            if (this.isBlackListed(candidate.getId())) continue;
            this.blackListIfDuplicate(candidate);
            return this.setAvailable(true);
        }
        while (this.cursorIndex > 0) {
            this.checkNotClosed("previous()");
            --this.cursorIndex;
            this.cursors.get(this.cursorIndex).afterLast();
            while (this.cursors.get(this.cursorIndex).previous()) {
                this.checkNotClosed("previous()");
                candidate = (IndexEntry)this.cursors.get(this.cursorIndex).get();
                if (this.isBlackListed(candidate.getId())) continue;
                this.blackListIfDuplicate(candidate);
                return this.setAvailable(true);
            }
        }
        return this.setAvailable(false);
    }

    @Override
    public boolean next() throws Exception {
        IndexEntry candidate;
        while (this.cursors.get(this.cursorIndex).next()) {
            this.checkNotClosed("next()");
            candidate = (IndexEntry)this.cursors.get(this.cursorIndex).get();
            if (this.isBlackListed(candidate.getId())) continue;
            this.blackListIfDuplicate(candidate);
            return this.setAvailable(true);
        }
        while (this.cursorIndex < this.cursors.size() - 1) {
            this.checkNotClosed("previous()");
            ++this.cursorIndex;
            this.cursors.get(this.cursorIndex).beforeFirst();
            while (this.cursors.get(this.cursorIndex).next()) {
                this.checkNotClosed("previous()");
                candidate = (IndexEntry)this.cursors.get(this.cursorIndex).get();
                if (this.isBlackListed(candidate.getId())) continue;
                this.blackListIfDuplicate(candidate);
                return this.setAvailable(true);
            }
        }
        return this.setAvailable(false);
    }

    @Override
    public IndexEntry<V, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available()) {
            return (IndexEntry)this.cursors.get(this.cursorIndex).get();
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() throws Exception {
        super.close();
        for (IndexCursor<V, Entry, ID> cursor : this.cursors) {
            cursor.close();
        }
    }
}

