/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadBitString<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadBitString.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AbstractReadBitString(String name) {
        super(name);
    }

    protected abstract void setBitString(byte[] var1, E var2);

    @Override
    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() != 5) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        byte[] data = tlv.getValue().getData();
        this.setBitString(data, container);
        if (IS_DEBUG) {
            LOG.debug("BITSTRING value : {}", (Object)Strings.dumpBytes(data));
        }
    }
}

