/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.methodData.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.methodData.MethodDataContainer;
import org.apache.directory.shared.kerberos.codec.padata.PaDataContainer;
import org.apache.directory.shared.kerberos.components.PaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPaData
extends GrammarAction<MethodDataContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AddPaData.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddPaData() {
        super("Add a PA-DATA instance");
    }

    @Override
    public void action(MethodDataContainer methodDataContainer) throws DecoderException {
        TLV tlv = methodDataContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        Asn1Decoder paDataDecoder = new Asn1Decoder();
        PaDataContainer paDataContainer = new PaDataContainer();
        paDataContainer.setStream(methodDataContainer.getStream());
        methodDataContainer.rewind();
        paDataDecoder.decode(methodDataContainer.getStream(), paDataContainer);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        methodDataContainer.updateParent();
        PaData paData = paDataContainer.getPaData();
        methodDataContainer.addPaData(paData);
        if (IS_DEBUG) {
            LOG.debug("PA-DATA added : {}", paData);
        }
        methodDataContainer.setGrammarEndAllowed(true);
    }
}

