/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;

public class NotFilter
extends ConnectorFilter {
    public NotFilter(int tlvId) {
        super(tlvId);
    }

    public NotFilter() {
    }

    public void addFilter(Filter filter) throws DecoderException {
        if (this.filterSet != null) {
            throw new DecoderException(I18n.err(I18n.ERR_04057, new Object[0]));
        }
        super.addFilter(filter);
    }

    public Filter getNotFilter() {
        return (Filter)this.filterSet.get(0);
    }

    public void setNotFilter(Filter notFilter) throws DecoderException {
        if (this.filterSet != null) {
            throw new DecoderException(I18n.err(I18n.ERR_04057, new Object[0]));
        }
        super.addFilter(notFilter);
    }

    public int computeLength() {
        this.filtersLength = super.computeLength();
        return 1 + TLV.getNbBytes(this.filtersLength) + this.filtersLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        try {
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes(this.filtersLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        super.encode(buffer);
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('!').append(super.toString());
        return sb.toString();
    }
}

