/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel.Cancel;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel.CancelContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel.CancelStatesEnum;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CancelGrammar
extends AbstractGrammar<CancelContainer> {
    static final Logger LOG = LoggerFactory.getLogger(CancelGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<CancelContainer> instance = new CancelGrammar();

    private CancelGrammar() {
        this.setName(CancelGrammar.class.getName());
        this.transitions = new GrammarTransition[CancelStatesEnum.LAST_CANCEL_STATE.ordinal()][256];
        this.transitions[CancelStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(CancelStatesEnum.START_STATE, CancelStatesEnum.CANCEL_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction("Init Cancel"){

            public void action(Asn1Container container) {
                CancelContainer cancelContainer = (CancelContainer)container;
                Cancel cancel = new Cancel();
                cancelContainer.setCancel(cancel);
            }
        });
        this.transitions[CancelStatesEnum.CANCEL_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition(CancelStatesEnum.CANCEL_SEQUENCE_STATE, CancelStatesEnum.CANCEL_ID_STATE, UniversalTag.INTEGER.getValue(), new GrammarAction("Stores CancelId"){

            public void action(Asn1Container container) throws DecoderException {
                CancelContainer cancelContainer = (CancelContainer)container;
                Value value = cancelContainer.getCurrentTLV().getValue();
                try {
                    int cancelId = IntegerDecoder.parse(value, 0, Integer.MAX_VALUE);
                    if (IS_DEBUG) {
                        LOG.debug("CancelId = " + cancelId);
                    }
                    cancelContainer.getCancel().setCancelId(cancelId);
                    cancelContainer.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err(I18n.ERR_04031, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static Grammar<CancelContainer> getInstance() {
        return instance;
    }
}

